/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StringStatsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean showDistribution;
    public static final JsonpDeserializer<StringStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringStatsAggregation::setupStringStatsAggregationDeserializer, Builder::build);

    public StringStatsAggregation(Builder builder) {
        super(builder);
        this.showDistribution = builder.showDistribution;
    }

    public StringStatsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "string_stats";
    }

    @Nullable
    public Boolean showDistribution() {
        return this.showDistribution;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.showDistribution != null) {
            generator.writeKey("show_distribution");
            generator.write(this.showDistribution.booleanValue());
        }
    }

    protected static void setupStringStatsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::showDistribution, JsonpDeserializer.booleanDeserializer(), "show_distribution", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringStatsAggregation> {
        @Nullable
        private Boolean showDistribution;

        public Builder showDistribution(@Nullable Boolean value) {
            this.showDistribution = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringStatsAggregation build() {
            return new StringStatsAggregation(this);
        }
    }
}

