/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.HdrMethod;
import co.elastic.clients.elasticsearch._types.aggregations.TDigest;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PercentilesAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final List<Double> percents;
    @Nullable
    private final HdrMethod hdr;
    @Nullable
    private final TDigest tdigest;
    public static final JsonpDeserializer<PercentilesAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesAggregation::setupPercentilesAggregationDeserializer, Builder::build);

    public PercentilesAggregation(Builder builder) {
        super(builder);
        this.keyed = builder.keyed;
        this.percents = ModelTypeHelper.unmodifiable(builder.percents);
        this.hdr = builder.hdr;
        this.tdigest = builder.tdigest;
    }

    public PercentilesAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "percentiles";
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public List<Double> percents() {
        return this.percents;
    }

    @Nullable
    public HdrMethod hdr() {
        return this.hdr;
    }

    @Nullable
    public TDigest tdigest() {
        return this.tdigest;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.percents != null) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
        if (this.hdr != null) {
            generator.writeKey("hdr");
            this.hdr.serialize(generator, mapper);
        }
        if (this.tdigest != null) {
            generator.writeKey("tdigest");
            this.tdigest.serialize(generator, mapper);
        }
    }

    protected static void setupPercentilesAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents", new String[0]);
        op.add(Builder::hdr, HdrMethod._DESERIALIZER, "hdr", new String[0]);
        op.add(Builder::tdigest, TDigest._DESERIALIZER, "tdigest", new String[0]);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercentilesAggregation> {
        @Nullable
        private Boolean keyed;
        @Nullable
        private List<Double> percents;
        @Nullable
        private HdrMethod hdr;
        @Nullable
        private TDigest tdigest;

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        public Builder percents(@Nullable List<Double> value) {
            this.percents = value;
            return this;
        }

        public Builder percents(Double ... value) {
            this.percents = Arrays.asList(value);
            return this;
        }

        public Builder addPercents(Double value) {
            if (this.percents == null) {
                this.percents = new ArrayList<Double>();
            }
            this.percents.add(value);
            return this;
        }

        public Builder hdr(@Nullable HdrMethod value) {
            this.hdr = value;
            return this;
        }

        public Builder hdr(Function<HdrMethod.Builder, ObjectBuilder<HdrMethod>> fn) {
            return this.hdr(fn.apply(new HdrMethod.Builder()).build());
        }

        public Builder tdigest(@Nullable TDigest value) {
            this.tdigest = value;
            return this;
        }

        public Builder tdigest(Function<TDigest.Builder, ObjectBuilder<TDigest>> fn) {
            return this.tdigest(fn.apply(new TDigest.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercentilesAggregation build() {
            return new PercentilesAggregation(this);
        }
    }
}

