/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.NormalizeMethod;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NormalizeAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final NormalizeMethod method;
    public static final JsonpDeserializer<NormalizeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NormalizeAggregation::setupNormalizeAggregationDeserializer, Builder::build);

    public NormalizeAggregation(Builder builder) {
        super(builder);
        this.method = builder.method;
    }

    public NormalizeAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "normalize";
    }

    @Nullable
    public NormalizeMethod method() {
        return this.method;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
    }

    protected static void setupNormalizeAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::method, NormalizeMethod._DESERIALIZER, "method", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NormalizeAggregation> {
        @Nullable
        private NormalizeMethod method;

        public Builder method(@Nullable NormalizeMethod value) {
            this.method = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NormalizeAggregation build() {
            return new NormalizeAggregation(this);
        }
    }
}

