/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MovingAverageModel;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MovingAverageAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean minimize;
    @Nullable
    private final MovingAverageModel model;
    private final JsonValue settings;
    @Nullable
    private final Integer predict;
    @Nullable
    private final Integer window;
    public static final JsonpDeserializer<MovingAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingAverageAggregation::setupMovingAverageAggregationDeserializer, Builder::build);

    public MovingAverageAggregation(Builder builder) {
        super(builder);
        this.minimize = builder.minimize;
        this.model = builder.model;
        this.settings = Objects.requireNonNull(builder.settings, "settings");
        this.predict = builder.predict;
        this.window = builder.window;
    }

    public MovingAverageAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "moving_avg";
    }

    @Nullable
    public Boolean minimize() {
        return this.minimize;
    }

    @Nullable
    public MovingAverageModel model() {
        return this.model;
    }

    public JsonValue settings() {
        return this.settings;
    }

    @Nullable
    public Integer predict() {
        return this.predict;
    }

    @Nullable
    public Integer window() {
        return this.window;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.minimize != null) {
            generator.writeKey("minimize");
            generator.write(this.minimize.booleanValue());
        }
        if (this.model != null) {
            generator.writeKey("model");
            this.model.serialize(generator, mapper);
        }
        generator.writeKey("settings");
        generator.write(this.settings);
        if (this.predict != null) {
            generator.writeKey("predict");
            generator.write(this.predict.intValue());
        }
        if (this.window != null) {
            generator.writeKey("window");
            generator.write(this.window.intValue());
        }
    }

    protected static void setupMovingAverageAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::minimize, JsonpDeserializer.booleanDeserializer(), "minimize", new String[0]);
        op.add(Builder::model, MovingAverageModel._DESERIALIZER, "model", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.jsonValueDeserializer(), "settings", new String[0]);
        op.add(Builder::predict, JsonpDeserializer.integerDeserializer(), "predict", new String[0]);
        op.add(Builder::window, JsonpDeserializer.integerDeserializer(), "window", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MovingAverageAggregation> {
        @Nullable
        private Boolean minimize;
        @Nullable
        private MovingAverageModel model;
        private JsonValue settings;
        @Nullable
        private Integer predict;
        @Nullable
        private Integer window;

        public Builder minimize(@Nullable Boolean value) {
            this.minimize = value;
            return this;
        }

        public Builder model(@Nullable MovingAverageModel value) {
            this.model = value;
            return this;
        }

        public Builder settings(JsonValue value) {
            this.settings = value;
            return this;
        }

        public Builder predict(@Nullable Integer value) {
            this.predict = value;
            return this;
        }

        public Builder window(@Nullable Integer value) {
            this.window = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MovingAverageAggregation build() {
            return new MovingAverageAggregation(this);
        }
    }
}

