/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.IpRangeAggregationRange;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IpRangeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final List<IpRangeAggregationRange> ranges;
    public static final JsonpDeserializer<IpRangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpRangeAggregation::setupIpRangeAggregationDeserializer, Builder::build);

    public IpRangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.ranges = ModelTypeHelper.unmodifiable(builder.ranges);
    }

    public IpRangeAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "ip_range";
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public List<IpRangeAggregationRange> ranges() {
        return this.ranges;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.ranges != null) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (IpRangeAggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIpRangeAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(IpRangeAggregationRange._DESERIALIZER), "ranges", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpRangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private List<IpRangeAggregationRange> ranges;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder ranges(@Nullable List<IpRangeAggregationRange> value) {
            this.ranges = value;
            return this;
        }

        public Builder ranges(IpRangeAggregationRange ... value) {
            this.ranges = Arrays.asList(value);
            return this;
        }

        public Builder addRanges(IpRangeAggregationRange value) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<IpRangeAggregationRange>();
            }
            this.ranges.add(value);
            return this;
        }

        public Builder ranges(Function<IpRangeAggregationRange.Builder, ObjectBuilder<IpRangeAggregationRange>> fn) {
            return this.ranges(fn.apply(new IpRangeAggregationRange.Builder()).build());
        }

        public Builder addRanges(Function<IpRangeAggregationRange.Builder, ObjectBuilder<IpRangeAggregationRange>> fn) {
            return this.addRanges(fn.apply(new IpRangeAggregationRange.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpRangeAggregation build() {
            return new IpRangeAggregation(this);
        }
    }
}

