/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationRange;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoDistanceAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final String field;
    @Nullable
    private final JsonValue origin;
    @Nullable
    private final List<AggregationRange> ranges;
    @Nullable
    private final DistanceUnit unit;
    public static final JsonpDeserializer<GeoDistanceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceAggregation::setupGeoDistanceAggregationDeserializer, Builder::build);

    public GeoDistanceAggregation(Builder builder) {
        super(builder);
        this.distanceType = builder.distanceType;
        this.field = builder.field;
        this.origin = builder.origin;
        this.ranges = ModelTypeHelper.unmodifiable(builder.ranges);
        this.unit = builder.unit;
    }

    public GeoDistanceAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_distance";
    }

    @Nullable
    public GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public JsonValue origin() {
        return this.origin;
    }

    @Nullable
    public List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public DistanceUnit unit() {
        return this.unit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.origin != null) {
            generator.writeKey("origin");
            generator.write(this.origin);
        }
        if (this.ranges != null) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    protected static void setupGeoDistanceAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::origin, JsonpDeserializer.jsonValueDeserializer(), "origin", new String[0]);
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges", new String[0]);
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceAggregation> {
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private String field;
        @Nullable
        private JsonValue origin;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private DistanceUnit unit;

        public Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder origin(@Nullable JsonValue value) {
            this.origin = value;
            return this;
        }

        public Builder ranges(@Nullable List<AggregationRange> value) {
            this.ranges = value;
            return this;
        }

        public Builder ranges(AggregationRange ... value) {
            this.ranges = Arrays.asList(value);
            return this;
        }

        public Builder addRanges(AggregationRange value) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<AggregationRange>();
            }
            this.ranges.add(value);
            return this;
        }

        public Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build());
        }

        public Builder addRanges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.addRanges(fn.apply(new AggregationRange.Builder()).build());
        }

        public Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceAggregation build() {
            return new GeoDistanceAggregation(this);
        }
    }
}

