/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExtendedStatsBucketAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double sigma;
    public static final JsonpDeserializer<ExtendedStatsBucketAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedStatsBucketAggregation::setupExtendedStatsBucketAggregationDeserializer, Builder::build);

    public ExtendedStatsBucketAggregation(Builder builder) {
        super(builder);
        this.sigma = builder.sigma;
    }

    public ExtendedStatsBucketAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "extended_stats_bucket";
    }

    @Nullable
    public Double sigma() {
        return this.sigma;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sigma != null) {
            generator.writeKey("sigma");
            generator.write(this.sigma.doubleValue());
        }
    }

    protected static void setupExtendedStatsBucketAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::sigma, JsonpDeserializer.doubleDeserializer(), "sigma", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedStatsBucketAggregation> {
        @Nullable
        private Double sigma;

        public Builder sigma(@Nullable Double value) {
            this.sigma = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedStatsBucketAggregation build() {
            return new ExtendedStatsBucketAggregation(this);
        }
    }
}

