/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ExtendedBounds<T>
implements JsonpSerializable {
    private final T max;
    private final T min;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    public ExtendedBounds(Builder<T> builder) {
        this.max = Objects.requireNonNull(((Builder)builder).max, "max");
        this.min = Objects.requireNonNull(((Builder)builder).min, "min");
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public ExtendedBounds(Function<Builder<T>, Builder<T>> fn) {
        this(fn.apply(new Builder()));
    }

    public T max() {
        return this.max;
    }

    public T min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max");
        JsonpUtils.serialize(this.max, generator, this.tSerializer, mapper);
        generator.writeKey("min");
        JsonpUtils.serialize(this.min, generator, this.tSerializer, mapper);
    }

    public static <T> JsonpDeserializer<ExtendedBounds<T>> createExtendedBoundsDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> ExtendedBounds.setupExtendedBoundsDeserializer(op, tDeserializer));
    }

    protected static <T> void setupExtendedBoundsDeserializer(DelegatingDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::max, tDeserializer, "max", new String[0]);
        op.add(Builder::min, tDeserializer, "min", new String[0]);
    }

    public static class Builder<T>
    implements ObjectBuilder<ExtendedBounds<T>> {
        private T max;
        private T min;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public Builder<T> max(T value) {
            this.max = value;
            return this;
        }

        public Builder<T> min(T value) {
            this.min = value;
            return this;
        }

        public Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        public ExtendedBounds<T> build() {
            return new ExtendedBounds(this);
        }
    }
}

