/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BucketScriptAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final JsonValue script;
    public static final JsonpDeserializer<BucketScriptAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketScriptAggregation::setupBucketScriptAggregationDeserializer, Builder::build);

    public BucketScriptAggregation(Builder builder) {
        super(builder);
        this.script = builder.script;
    }

    public BucketScriptAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "bucket_script";
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
    }

    protected static void setupBucketScriptAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketScriptAggregation> {
        @Nullable
        private JsonValue script;

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketScriptAggregation build() {
            return new BucketScriptAggregation(this);
        }
    }
}

