/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SlicedScroll
implements JsonpSerializable {
    @Nullable
    private final String field;
    private final int id;
    private final int max;
    public static final JsonpDeserializer<SlicedScroll> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlicedScroll::setupSlicedScrollDeserializer, Builder::build);

    public SlicedScroll(Builder builder) {
        this.field = builder.field;
        this.id = Objects.requireNonNull(builder.id, "id");
        this.max = Objects.requireNonNull(builder.max, "max");
    }

    public SlicedScroll(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String field() {
        return this.field;
    }

    public int id() {
        return this.id;
    }

    public int max() {
        return this.max;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("max");
        generator.write(this.max);
    }

    protected static void setupSlicedScrollDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::id, JsonpDeserializer.integerDeserializer(), "id", new String[0]);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SlicedScroll> {
        @Nullable
        private String field;
        private Integer id;
        private Integer max;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder id(int value) {
            this.id = value;
            return this;
        }

        public Builder max(int value) {
            this.max = value;
            return this;
        }

        @Override
        public SlicedScroll build() {
            return new SlicedScroll(this);
        }
    }
}

