/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestDefinition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SearchTransform
implements TransformVariant,
JsonpSerializable {
    private final SearchInputRequestDefinition request;
    private final String timeout;
    public static final JsonpDeserializer<SearchTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchTransform::setupSearchTransformDeserializer, Builder::build);

    public SearchTransform(Builder builder) {
        this.request = Objects.requireNonNull(builder.request, "request");
        this.timeout = Objects.requireNonNull(builder.timeout, "timeout");
    }

    public SearchTransform(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "search";
    }

    public SearchInputRequestDefinition request() {
        return this.request;
    }

    public String timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        generator.writeKey("timeout");
        generator.write(this.timeout);
    }

    protected static void setupSearchTransformDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::request, SearchInputRequestDefinition._DESERIALIZER, "request", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchTransform> {
        private SearchInputRequestDefinition request;
        private String timeout;

        public Builder request(SearchInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public Builder request(Function<SearchInputRequestDefinition.Builder, ObjectBuilder<SearchInputRequestDefinition>> fn) {
            return this.request(fn.apply(new SearchInputRequestDefinition.Builder()).build());
        }

        public Builder timeout(String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public SearchTransform build() {
            return new SearchTransform(this);
        }
    }
}

