/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ScriptTransform
implements TransformVariant,
JsonpSerializable {
    private final String lang;
    private final Map<String, JsonData> params;
    public static final JsonpDeserializer<ScriptTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptTransform::setupScriptTransformDeserializer, Builder::build);

    public ScriptTransform(Builder builder) {
        this.lang = Objects.requireNonNull(builder.lang, "lang");
        this.params = ModelTypeHelper.unmodifiableNonNull(builder.params, "params");
    }

    public ScriptTransform(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "script";
    }

    public String lang() {
        return this.lang;
    }

    public Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        generator.write(this.lang);
        generator.writeKey("params");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupScriptTransformDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ScriptTransform> {
        private String lang;
        private Map<String, JsonData> params;

        public Builder lang(String value) {
            this.lang = value;
            return this;
        }

        public Builder params(Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        @Override
        public ScriptTransform build() {
            return new ScriptTransform(this);
        }
    }
}

