/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexingStats
implements JsonpSerializable {
    private final long indexCurrent;
    private final long deleteCurrent;
    @Nullable
    private final String deleteTime;
    private final long deleteTimeInMillis;
    private final long deleteTotal;
    private final boolean isThrottled;
    private final long noopUpdateTotal;
    @Nullable
    private final String throttleTime;
    private final long throttleTimeInMillis;
    @Nullable
    private final String indexTime;
    private final long indexTimeInMillis;
    private final long indexTotal;
    private final long indexFailed;
    @Nullable
    private final Map<String, IndexingStats> types;
    public static final JsonpDeserializer<IndexingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingStats::setupIndexingStatsDeserializer, Builder::build);

    public IndexingStats(Builder builder) {
        this.indexCurrent = Objects.requireNonNull(builder.indexCurrent, "index_current");
        this.deleteCurrent = Objects.requireNonNull(builder.deleteCurrent, "delete_current");
        this.deleteTime = builder.deleteTime;
        this.deleteTimeInMillis = Objects.requireNonNull(builder.deleteTimeInMillis, "delete_time_in_millis");
        this.deleteTotal = Objects.requireNonNull(builder.deleteTotal, "delete_total");
        this.isThrottled = Objects.requireNonNull(builder.isThrottled, "is_throttled");
        this.noopUpdateTotal = Objects.requireNonNull(builder.noopUpdateTotal, "noop_update_total");
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = Objects.requireNonNull(builder.throttleTimeInMillis, "throttle_time_in_millis");
        this.indexTime = builder.indexTime;
        this.indexTimeInMillis = Objects.requireNonNull(builder.indexTimeInMillis, "index_time_in_millis");
        this.indexTotal = Objects.requireNonNull(builder.indexTotal, "index_total");
        this.indexFailed = Objects.requireNonNull(builder.indexFailed, "index_failed");
        this.types = ModelTypeHelper.unmodifiable(builder.types);
    }

    public IndexingStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long indexCurrent() {
        return this.indexCurrent;
    }

    public long deleteCurrent() {
        return this.deleteCurrent;
    }

    @Nullable
    public String deleteTime() {
        return this.deleteTime;
    }

    public long deleteTimeInMillis() {
        return this.deleteTimeInMillis;
    }

    public long deleteTotal() {
        return this.deleteTotal;
    }

    public boolean isThrottled() {
        return this.isThrottled;
    }

    public long noopUpdateTotal() {
        return this.noopUpdateTotal;
    }

    @Nullable
    public String throttleTime() {
        return this.throttleTime;
    }

    public long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Nullable
    public String indexTime() {
        return this.indexTime;
    }

    public long indexTimeInMillis() {
        return this.indexTimeInMillis;
    }

    public long indexTotal() {
        return this.indexTotal;
    }

    public long indexFailed() {
        return this.indexFailed;
    }

    @Nullable
    public Map<String, IndexingStats> types() {
        return this.types;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_current");
        generator.write(this.indexCurrent);
        generator.writeKey("delete_current");
        generator.write(this.deleteCurrent);
        if (this.deleteTime != null) {
            generator.writeKey("delete_time");
            generator.write(this.deleteTime);
        }
        generator.writeKey("delete_time_in_millis");
        generator.write(this.deleteTimeInMillis);
        generator.writeKey("delete_total");
        generator.write(this.deleteTotal);
        generator.writeKey("is_throttled");
        generator.write(this.isThrottled);
        generator.writeKey("noop_update_total");
        generator.write(this.noopUpdateTotal);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            generator.write(this.throttleTime);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
        if (this.indexTime != null) {
            generator.writeKey("index_time");
            generator.write(this.indexTime);
        }
        generator.writeKey("index_time_in_millis");
        generator.write(this.indexTimeInMillis);
        generator.writeKey("index_total");
        generator.write(this.indexTotal);
        generator.writeKey("index_failed");
        generator.write(this.indexFailed);
        if (this.types != null) {
            generator.writeKey("types");
            generator.writeStartObject();
            for (Map.Entry<String, IndexingStats> item0 : this.types.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexingStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexCurrent, JsonpDeserializer.longDeserializer(), "index_current", new String[0]);
        op.add(Builder::deleteCurrent, JsonpDeserializer.longDeserializer(), "delete_current", new String[0]);
        op.add(Builder::deleteTime, JsonpDeserializer.stringDeserializer(), "delete_time", new String[0]);
        op.add(Builder::deleteTimeInMillis, JsonpDeserializer.longDeserializer(), "delete_time_in_millis", new String[0]);
        op.add(Builder::deleteTotal, JsonpDeserializer.longDeserializer(), "delete_total", new String[0]);
        op.add(Builder::isThrottled, JsonpDeserializer.booleanDeserializer(), "is_throttled", new String[0]);
        op.add(Builder::noopUpdateTotal, JsonpDeserializer.longDeserializer(), "noop_update_total", new String[0]);
        op.add(Builder::throttleTime, JsonpDeserializer.stringDeserializer(), "throttle_time", new String[0]);
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis", new String[0]);
        op.add(Builder::indexTime, JsonpDeserializer.stringDeserializer(), "index_time", new String[0]);
        op.add(Builder::indexTimeInMillis, JsonpDeserializer.longDeserializer(), "index_time_in_millis", new String[0]);
        op.add(Builder::indexTotal, JsonpDeserializer.longDeserializer(), "index_total", new String[0]);
        op.add(Builder::indexFailed, JsonpDeserializer.longDeserializer(), "index_failed", new String[0]);
        op.add(Builder::types, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "types", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexingStats> {
        private Long indexCurrent;
        private Long deleteCurrent;
        @Nullable
        private String deleteTime;
        private Long deleteTimeInMillis;
        private Long deleteTotal;
        private Boolean isThrottled;
        private Long noopUpdateTotal;
        @Nullable
        private String throttleTime;
        private Long throttleTimeInMillis;
        @Nullable
        private String indexTime;
        private Long indexTimeInMillis;
        private Long indexTotal;
        private Long indexFailed;
        @Nullable
        private Map<String, IndexingStats> types;

        public Builder indexCurrent(long value) {
            this.indexCurrent = value;
            return this;
        }

        public Builder deleteCurrent(long value) {
            this.deleteCurrent = value;
            return this;
        }

        public Builder deleteTime(@Nullable String value) {
            this.deleteTime = value;
            return this;
        }

        public Builder deleteTimeInMillis(long value) {
            this.deleteTimeInMillis = value;
            return this;
        }

        public Builder deleteTotal(long value) {
            this.deleteTotal = value;
            return this;
        }

        public Builder isThrottled(boolean value) {
            this.isThrottled = value;
            return this;
        }

        public Builder noopUpdateTotal(long value) {
            this.noopUpdateTotal = value;
            return this;
        }

        public Builder throttleTime(@Nullable String value) {
            this.throttleTime = value;
            return this;
        }

        public Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        public Builder indexTime(@Nullable String value) {
            this.indexTime = value;
            return this;
        }

        public Builder indexTimeInMillis(long value) {
            this.indexTimeInMillis = value;
            return this;
        }

        public Builder indexTotal(long value) {
            this.indexTotal = value;
            return this;
        }

        public Builder indexFailed(long value) {
            this.indexFailed = value;
            return this;
        }

        public Builder types(@Nullable Map<String, IndexingStats> value) {
            this.types = value;
            return this;
        }

        public Builder putTypes(String key, IndexingStats value) {
            if (this.types == null) {
                this.types = new HashMap<String, IndexingStats>();
            }
            this.types.put(key, value);
            return this;
        }

        public Builder types(String key, Function<Builder, ObjectBuilder<IndexingStats>> fn) {
            return this.types(Collections.singletonMap(key, fn.apply(new Builder()).build()));
        }

        public Builder putTypes(String key, Function<Builder, ObjectBuilder<IndexingStats>> fn) {
            return this.putTypes(key, fn.apply(new Builder()).build());
        }

        @Override
        public IndexingStats build() {
            return new IndexingStats(this);
        }
    }
}

