/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldMemoryUsage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FielddataStats
implements JsonpSerializable {
    @Nullable
    private final Long evictions;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    @Nullable
    private final Map<String, FieldMemoryUsage> fields;
    public static final JsonpDeserializer<FielddataStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FielddataStats::setupFielddataStatsDeserializer, Builder::build);

    public FielddataStats(Builder builder) {
        this.evictions = builder.evictions;
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = Objects.requireNonNull(builder.memorySizeInBytes, "memory_size_in_bytes");
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
    }

    public FielddataStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Long evictions() {
        return this.evictions;
    }

    @Nullable
    public String memorySize() {
        return this.memorySize;
    }

    public long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    @Nullable
    public Map<String, FieldMemoryUsage> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.evictions != null) {
            generator.writeKey("evictions");
            generator.write(this.evictions.longValue());
        }
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldMemoryUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFielddataStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions", new String[0]);
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size", new String[0]);
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldMemoryUsage._DESERIALIZER), "fields", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FielddataStats> {
        @Nullable
        private Long evictions;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        @Nullable
        private Map<String, FieldMemoryUsage> fields;

        public Builder evictions(@Nullable Long value) {
            this.evictions = value;
            return this;
        }

        public Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public Builder fields(@Nullable Map<String, FieldMemoryUsage> value) {
            this.fields = value;
            return this;
        }

        public Builder putFields(String key, FieldMemoryUsage value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, FieldMemoryUsage>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder fields(String key, Function<FieldMemoryUsage.Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
            return this.fields(Collections.singletonMap(key, fn.apply(new FieldMemoryUsage.Builder()).build()));
        }

        public Builder putFields(String key, Function<FieldMemoryUsage.Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
            return this.putFields(key, fn.apply(new FieldMemoryUsage.Builder()).build());
        }

        @Override
        public FielddataStats build() {
            return new FielddataStats(this);
        }
    }
}

