/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BulkStats
implements JsonpSerializable {
    private final long totalOperations;
    @Nullable
    private final String totalTime;
    private final long totalTimeInMillis;
    @Nullable
    private final String totalSize;
    private final long totalSizeInBytes;
    @Nullable
    private final String avgTime;
    private final long avgTimeInMillis;
    @Nullable
    private final String avgSize;
    private final long avgSizeInBytes;
    public static final JsonpDeserializer<BulkStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkStats::setupBulkStatsDeserializer, Builder::build);

    public BulkStats(Builder builder) {
        this.totalOperations = Objects.requireNonNull(builder.totalOperations, "total_operations");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
        this.totalSize = builder.totalSize;
        this.totalSizeInBytes = Objects.requireNonNull(builder.totalSizeInBytes, "total_size_in_bytes");
        this.avgTime = builder.avgTime;
        this.avgTimeInMillis = Objects.requireNonNull(builder.avgTimeInMillis, "avg_time_in_millis");
        this.avgSize = builder.avgSize;
        this.avgSizeInBytes = Objects.requireNonNull(builder.avgSizeInBytes, "avg_size_in_bytes");
    }

    public BulkStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long totalOperations() {
        return this.totalOperations;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Nullable
    public String totalSize() {
        return this.totalSize;
    }

    public long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public String avgTime() {
        return this.avgTime;
    }

    public long avgTimeInMillis() {
        return this.avgTimeInMillis;
    }

    @Nullable
    public String avgSize() {
        return this.avgSize;
    }

    public long avgSizeInBytes() {
        return this.avgSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_operations");
        generator.write(this.totalOperations);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (this.avgTime != null) {
            generator.writeKey("avg_time");
            generator.write(this.avgTime);
        }
        generator.writeKey("avg_time_in_millis");
        generator.write(this.avgTimeInMillis);
        if (this.avgSize != null) {
            generator.writeKey("avg_size");
            generator.write(this.avgSize);
        }
        generator.writeKey("avg_size_in_bytes");
        generator.write(this.avgSizeInBytes);
    }

    protected static void setupBulkStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::totalOperations, JsonpDeserializer.longDeserializer(), "total_operations", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis", new String[0]);
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size", new String[0]);
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes", new String[0]);
        op.add(Builder::avgTime, JsonpDeserializer.stringDeserializer(), "avg_time", new String[0]);
        op.add(Builder::avgTimeInMillis, JsonpDeserializer.longDeserializer(), "avg_time_in_millis", new String[0]);
        op.add(Builder::avgSize, JsonpDeserializer.stringDeserializer(), "avg_size", new String[0]);
        op.add(Builder::avgSizeInBytes, JsonpDeserializer.longDeserializer(), "avg_size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BulkStats> {
        private Long totalOperations;
        @Nullable
        private String totalTime;
        private Long totalTimeInMillis;
        @Nullable
        private String totalSize;
        private Long totalSizeInBytes;
        @Nullable
        private String avgTime;
        private Long avgTimeInMillis;
        @Nullable
        private String avgSize;
        private Long avgSizeInBytes;

        public Builder totalOperations(long value) {
            this.totalOperations = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        public Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public Builder avgTime(@Nullable String value) {
            this.avgTime = value;
            return this;
        }

        public Builder avgTimeInMillis(long value) {
            this.avgTimeInMillis = value;
            return this;
        }

        public Builder avgSize(@Nullable String value) {
            this.avgSize = value;
            return this;
        }

        public Builder avgSizeInBytes(long value) {
            this.avgSizeInBytes = value;
            return this;
        }

        @Override
        public BulkStats build() {
            return new BulkStats(this);
        }
    }
}

