/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NestedIdentity
implements JsonpSerializable {
    private final String field;
    private final int offset;
    @Nullable
    private final NestedIdentity nested;
    public static final JsonpDeserializer<NestedIdentity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedIdentity::setupNestedIdentityDeserializer, Builder::build);

    public NestedIdentity(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.offset = Objects.requireNonNull(builder.offset, "offset");
        this.nested = builder.nested;
    }

    public NestedIdentity(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    public int offset() {
        return this.offset;
    }

    @Nullable
    public NestedIdentity nested() {
        return this.nested;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("offset");
        generator.write(this.offset);
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
    }

    protected static void setupNestedIdentityDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset", new String[0]);
        op.add(Builder::nested, _DESERIALIZER, "_nested", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NestedIdentity> {
        private String field;
        private Integer offset;
        @Nullable
        private NestedIdentity nested;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder offset(int value) {
            this.offset = value;
            return this;
        }

        public Builder nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        public Builder nested(Function<Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new Builder()).build());
        }

        @Override
        public NestedIdentity build() {
            return new NestedIdentity(this);
        }
    }
}

