/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.reindex;

import co.elastic.clients.elasticsearch._core.reindex.RemoteSource;
import co.elastic.clients.elasticsearch._core.reindex.SourceRuntimeMapping;
import co.elastic.clients.elasticsearch._types.SlicedScroll;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Source
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final Query query;
    @Nullable
    private final RemoteSource remote;
    @Nullable
    private final Integer size;
    @Nullable
    private final SlicedScroll slice;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final List<String> sourceFields;
    @Nullable
    private final Map<String, SourceRuntimeMapping> runtimeMappings;
    public static final JsonpDeserializer<Source> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Source::setupSourceDeserializer, Builder::build);

    public Source(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.query = builder.query;
        this.remote = builder.remote;
        this.size = builder.size;
        this.slice = builder.slice;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.sourceFields = ModelTypeHelper.unmodifiable(builder.sourceFields);
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
    }

    public Source(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public RemoteSource remote() {
        return this.remote;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public SlicedScroll slice() {
        return this.slice;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public List<String> sourceFields() {
        return this.sourceFields;
    }

    @Nullable
    public Map<String, SourceRuntimeMapping> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.writeStartArray();
        for (String string : this.index) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.remote != null) {
            generator.writeKey("remote");
            this.remote.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.sourceFields != null) {
            generator.writeKey("_source");
            generator.writeStartArray();
            for (String string : this.sourceFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((SourceRuntimeMapping)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSourceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::remote, RemoteSource._DESERIALIZER, "remote", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::sourceFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_source", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(SourceRuntimeMapping._DESERIALIZER), "runtime_mappings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Source> {
        private List<String> index;
        @Nullable
        private Query query;
        @Nullable
        private RemoteSource remote;
        @Nullable
        private Integer size;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private List<String> sourceFields;
        @Nullable
        private Map<String, SourceRuntimeMapping> runtimeMappings;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder remote(@Nullable RemoteSource value) {
            this.remote = value;
            return this;
        }

        public Builder remote(Function<RemoteSource.Builder, ObjectBuilder<RemoteSource>> fn) {
            return this.remote(fn.apply(new RemoteSource.Builder()).build());
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        public Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder sourceFields(@Nullable List<String> value) {
            this.sourceFields = value;
            return this;
        }

        public Builder sourceFields(String ... value) {
            this.sourceFields = Arrays.asList(value);
            return this;
        }

        public Builder addSourceFields(String value) {
            if (this.sourceFields == null) {
                this.sourceFields = new ArrayList<String>();
            }
            this.sourceFields.add(value);
            return this;
        }

        public Builder runtimeMappings(@Nullable Map<String, SourceRuntimeMapping> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, SourceRuntimeMapping value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, SourceRuntimeMapping>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<SourceRuntimeMapping.Builder, ObjectBuilder<SourceRuntimeMapping>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new SourceRuntimeMapping.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<SourceRuntimeMapping.Builder, ObjectBuilder<SourceRuntimeMapping>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new SourceRuntimeMapping.Builder()).build());
        }

        @Override
        public Source build() {
            return new Source(this);
        }
    }
}

