/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.rank_eval;

import co.elastic.clients.elasticsearch._core.rank_eval.DocumentRating;
import co.elastic.clients.elasticsearch._core.rank_eval.RankEvalQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RankEvalRequestItem
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final RankEvalQuery request;
    private final List<DocumentRating> ratings;
    @Nullable
    private final String templateId;
    @Nullable
    private final Map<String, JsonData> params;
    public static final JsonpDeserializer<RankEvalRequestItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalRequestItem::setupRankEvalRequestItemDeserializer, Builder::build);

    public RankEvalRequestItem(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.request = builder.request;
        this.ratings = ModelTypeHelper.unmodifiableNonNull(builder.ratings, "ratings");
        this.templateId = builder.templateId;
        this.params = ModelTypeHelper.unmodifiable(builder.params);
    }

    public RankEvalRequestItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public RankEvalQuery request() {
        return this.request;
    }

    public List<DocumentRating> ratings() {
        return this.ratings;
    }

    @Nullable
    public String templateId() {
        return this.templateId;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        generator.writeKey("ratings");
        generator.writeStartArray();
        for (DocumentRating documentRating : this.ratings) {
            documentRating.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.templateId != null) {
            generator.writeKey("template_id");
            generator.write(this.templateId);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry entry : this.params.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRankEvalRequestItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::request, RankEvalQuery._DESERIALIZER, "request", new String[0]);
        op.add(Builder::ratings, JsonpDeserializer.arrayDeserializer(DocumentRating._DESERIALIZER), "ratings", new String[0]);
        op.add(Builder::templateId, JsonpDeserializer.stringDeserializer(), "template_id", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankEvalRequestItem> {
        private String id;
        @Nullable
        private RankEvalQuery request;
        private List<DocumentRating> ratings;
        @Nullable
        private String templateId;
        @Nullable
        private Map<String, JsonData> params;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder request(@Nullable RankEvalQuery value) {
            this.request = value;
            return this;
        }

        public Builder request(Function<RankEvalQuery.Builder, ObjectBuilder<RankEvalQuery>> fn) {
            return this.request(fn.apply(new RankEvalQuery.Builder()).build());
        }

        public Builder ratings(List<DocumentRating> value) {
            this.ratings = value;
            return this;
        }

        public Builder ratings(DocumentRating ... value) {
            this.ratings = Arrays.asList(value);
            return this;
        }

        public Builder addRatings(DocumentRating value) {
            if (this.ratings == null) {
                this.ratings = new ArrayList<DocumentRating>();
            }
            this.ratings.add(value);
            return this;
        }

        public Builder ratings(Function<DocumentRating.Builder, ObjectBuilder<DocumentRating>> fn) {
            return this.ratings(fn.apply(new DocumentRating.Builder()).build());
        }

        public Builder addRatings(Function<DocumentRating.Builder, ObjectBuilder<DocumentRating>> fn) {
            return this.addRatings(fn.apply(new DocumentRating.Builder()).build());
        }

        public Builder templateId(@Nullable String value) {
            this.templateId = value;
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        @Override
        public RankEvalRequestItem build() {
            return new RankEvalRequestItem(this);
        }
    }
}

