/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.search_shards.ShardStoreIndex;
import co.elastic.clients.elasticsearch._types.NodeAttributes;
import co.elastic.clients.elasticsearch._types.NodeShard;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class SearchShardsResponse
implements JsonpSerializable {
    private final Map<String, NodeAttributes> nodes;
    private final List<List<NodeShard>> shards;
    private final Map<String, ShardStoreIndex> indices;
    public static final JsonpDeserializer<SearchShardsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchShardsResponse::setupSearchShardsResponseDeserializer, Builder::build);

    public SearchShardsResponse(Builder builder) {
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public SearchShardsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, NodeAttributes> nodes() {
        return this.nodes;
    }

    public List<List<NodeShard>> shards() {
        return this.shards;
    }

    public Map<String, ShardStoreIndex> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, NodeAttributes> entry : this.nodes.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shards");
        generator.writeStartArray();
        for (List list : this.shards) {
            generator.writeStartArray();
            for (NodeShard item1 : list) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry entry : this.indices.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((ShardStoreIndex)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSearchShardsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeAttributes._DESERIALIZER), "nodes", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(NodeShard._DESERIALIZER)), "shards", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(ShardStoreIndex._DESERIALIZER), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchShardsResponse> {
        private Map<String, NodeAttributes> nodes;
        private List<List<NodeShard>> shards;
        private Map<String, ShardStoreIndex> indices;

        public Builder nodes(Map<String, NodeAttributes> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, NodeAttributes value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, NodeAttributes>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new NodeAttributes.Builder()).build()));
        }

        public Builder putNodes(String key, Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.putNodes(key, fn.apply(new NodeAttributes.Builder()).build());
        }

        public Builder shards(List<List<NodeShard>> value) {
            this.shards = value;
            return this;
        }

        public Builder shards(List<NodeShard> ... value) {
            this.shards = Arrays.asList(value);
            return this;
        }

        public Builder addShards(List<NodeShard> value) {
            if (this.shards == null) {
                this.shards = new ArrayList<List<NodeShard>>();
            }
            this.shards.add(value);
            return this;
        }

        public Builder indices(Map<String, ShardStoreIndex> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, ShardStoreIndex value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, ShardStoreIndex>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<ShardStoreIndex.Builder, ObjectBuilder<ShardStoreIndex>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new ShardStoreIndex.Builder()).build()));
        }

        public Builder putIndices(String key, Function<ShardStoreIndex.Builder, ObjectBuilder<ShardStoreIndex>> fn) {
            return this.putIndices(key, fn.apply(new ShardStoreIndex.Builder()).build());
        }

        @Override
        public SearchShardsResponse build() {
            return new SearchShardsResponse(this);
        }
    }
}

