/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.DefaultOperator;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SlicedScroll;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DeleteByQueryRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Conflicts conflicts;
    @Nullable
    private final DefaultOperator defaultOperator;
    @Nullable
    private final String df;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Long from;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final String routing;
    @Nullable
    private final String q;
    @Nullable
    private final String scroll;
    @Nullable
    private final Long scrollSize;
    @Nullable
    private final String searchTimeout;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Long size;
    @Nullable
    private final Long slices;
    @Nullable
    private final List<String> sort;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final List<String> stats;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean version;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final Boolean waitForCompletion;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final Query query;
    @Nullable
    private final SlicedScroll slice;
    public static final JsonpDeserializer<DeleteByQueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteByQueryRequest::setupDeleteByQueryRequestDeserializer, Builder::build);
    public static final Endpoint<DeleteByQueryRequest, DeleteByQueryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteByQueryRequest, DeleteByQueryResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_delete_by_query");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_delete_by_query");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.analyzer != null) {
            params.put("analyzer", request.analyzer);
        }
        if (request.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(request.analyzeWildcard));
        }
        if (request.conflicts != null) {
            params.put("conflicts", request.conflicts.toString());
        }
        if (request.defaultOperator != null) {
            params.put("default_operator", request.defaultOperator.toString());
        }
        if (request.df != null) {
            params.put("df", request.df);
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.lenient != null) {
            params.put("lenient", String.valueOf(request.lenient));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.requestCache != null) {
            params.put("request_cache", String.valueOf(request.requestCache));
        }
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.q != null) {
            params.put("q", request.q);
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll);
        }
        if (request.scrollSize != null) {
            params.put("scroll_size", String.valueOf(request.scrollSize));
        }
        if (request.searchTimeout != null) {
            params.put("search_timeout", request.searchTimeout);
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.toString());
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.slices != null) {
            params.put("slices", String.valueOf(request.slices));
        }
        if (request.sort != null) {
            params.put("sort", request.sort.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.source != null) {
            params.put("_source", JsonpUtils.toString(request.source));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.stats != null) {
            params.put("stats", request.stats.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.terminateAfter != null) {
            params.put("terminate_after", String.valueOf(request.terminateAfter));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, DeleteByQueryResponse._DESERIALIZER);

    public DeleteByQueryRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.allowNoIndices = builder.allowNoIndices;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.conflicts = builder.conflicts;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.from = builder.from;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.lenient = builder.lenient;
        this.preference = builder.preference;
        this.refresh = builder.refresh;
        this.requestCache = builder.requestCache;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.routing = builder.routing;
        this.q = builder.q;
        this.scroll = builder.scroll;
        this.scrollSize = builder.scrollSize;
        this.searchTimeout = builder.searchTimeout;
        this.searchType = builder.searchType;
        this.size = builder.size;
        this.slices = builder.slices;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(builder.sourceIncludes);
        this.stats = ModelTypeHelper.unmodifiable(builder.stats);
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForCompletion = builder.waitForCompletion;
        this.maxDocs = builder.maxDocs;
        this.query = builder.query;
        this.slice = builder.slice;
    }

    public DeleteByQueryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public Conflicts conflicts() {
        return this.conflicts;
    }

    @Nullable
    public DefaultOperator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public String df() {
        return this.df;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Long from() {
        return this.from;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String q() {
        return this.q;
    }

    @Nullable
    public String scroll() {
        return this.scroll;
    }

    @Nullable
    public Long scrollSize() {
        return this.scrollSize;
    }

    @Nullable
    public String searchTimeout() {
        return this.searchTimeout;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public Long size() {
        return this.size;
    }

    @Nullable
    public Long slices() {
        return this.slices;
    }

    @Nullable
    public List<String> sort() {
        return this.sort;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public List<String> stats() {
        return this.stats;
    }

    @Nullable
    public Long terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean version() {
        return this.version;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Nullable
    public Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public SlicedScroll slice() {
        return this.slice;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
    }

    protected static void setupDeleteByQueryRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DeleteByQueryRequest> {
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Conflicts conflicts;
        @Nullable
        private DefaultOperator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Long from;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean lenient;
        @Nullable
        private String preference;
        @Nullable
        private Boolean refresh;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private String routing;
        @Nullable
        private String q;
        @Nullable
        private String scroll;
        @Nullable
        private Long scrollSize;
        @Nullable
        private String searchTimeout;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Long size;
        @Nullable
        private Long slices;
        @Nullable
        private List<String> sort;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> stats;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean version;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private Boolean waitForCompletion;
        @Nullable
        private Long maxDocs;
        @Nullable
        private Query query;
        @Nullable
        private SlicedScroll slice;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder conflicts(@Nullable Conflicts value) {
            this.conflicts = value;
            return this;
        }

        public Builder defaultOperator(@Nullable DefaultOperator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder from(@Nullable Long value) {
            this.from = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        public Builder scroll(@Nullable String value) {
            this.scroll = value;
            return this;
        }

        public Builder scrollSize(@Nullable Long value) {
            this.scrollSize = value;
            return this;
        }

        public Builder searchTimeout(@Nullable String value) {
            this.searchTimeout = value;
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        public Builder slices(@Nullable Long value) {
            this.slices = value;
            return this;
        }

        public Builder sort(@Nullable List<String> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(String ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(String value) {
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder stats(@Nullable List<String> value) {
            this.stats = value;
            return this;
        }

        public Builder stats(String ... value) {
            this.stats = Arrays.asList(value);
            return this;
        }

        public Builder addStats(String value) {
            if (this.stats == null) {
                this.stats = new ArrayList<String>();
            }
            this.stats.add(value);
            return this;
        }

        public Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        public Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        public Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        @Override
        public DeleteByQueryRequest build() {
            return new DeleteByQueryRequest(this);
        }
    }
}

