/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.ResourceExtractionUtil;
import co.elastic.apm.agent.common.util.SystemStandardOutputLogger;
import co.elastic.apm.attach.ElasticAttachmentProvider;
import co.elastic.apm.attach.bytebuddy.agent.ByteBuddyAgent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class ElasticApmAttacher {
    private static final String TEMP_PROPERTIES_FILE_KEY = "c";

    public static void attach() {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadPropertiesFromClasspath("elasticapm.properties"));
    }

    public static void attach(String propertiesLocation) {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadPropertiesFromClasspath(propertiesLocation));
    }

    private static Map<String, String> loadPropertiesFromClasspath(String propertiesLocation) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Properties props = new Properties();
        try (InputStream resourceStream = ElasticApmAttacher.class.getClassLoader().getResourceAsStream(propertiesLocation);){
            if (resourceStream != null) {
                props.load(resourceStream);
                for (String propertyName : props.stringPropertyNames()) {
                    propertyMap.put(propertyName, props.getProperty(propertyName));
                }
            }
        }
        catch (IOException e) {
            SystemStandardOutputLogger.printStackTrace(e);
        }
        return propertyMap;
    }

    public static void attach(Map<String, String> configuration) {
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        ElasticApmAttacher.attach(ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE.resolve(), configuration);
    }

    static File createTempProperties(Map<String, String> configuration, @Nullable File folder) {
        File tempFile = null;
        if (!configuration.isEmpty()) {
            Properties properties = new Properties();
            properties.putAll(configuration);
            try {
                tempFile = File.createTempFile("elstcapm", ".tmp", folder);
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    properties.store(outputStream, null);
                }
            }
            catch (IOException e) {
                SystemStandardOutputLogger.printStackTrace(e);
            }
        }
        return tempFile;
    }

    public static void attach(String pid, Map<String, String> configuration) {
        ElasticApmAttacher.attach(pid, configuration, AgentJarFileHolder.INSTANCE.agentJarFile);
    }

    public static void attach(String pid, Map<String, String> configuration, File agentJarFile) {
        File tempFile;
        HashMap<String, String> config = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            config.put(entry.getKey(), entry.getValue());
        }
        if (!config.containsKey("activation_method")) {
            config.put("activation_method", "PROGRAMMATIC_SELF_ATTACH");
        }
        String agentArgs = (tempFile = ElasticApmAttacher.createTempProperties(config, null)) == null ? null : "c=" + tempFile.getAbsolutePath();
        ElasticApmAttacher.attachWithFallback(agentJarFile, pid, agentArgs);
        if (tempFile != null && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
    }

    private static void attachWithFallback(File agentJarFile, String pid, String agentArgs) {
        try {
            ByteBuddyAgent.attach(agentJarFile, pid, agentArgs, ElasticAttachmentProvider.get());
        }
        catch (RuntimeException e1) {
            try {
                ByteBuddyAgent.attach(agentJarFile, pid, agentArgs, ElasticAttachmentProvider.getFallback());
            }
            catch (RuntimeException e2) {
                SystemStandardOutputLogger.stdErrInfo("Unable to attach with fallback provider:");
                SystemStandardOutputLogger.printStackTrace(e2);
                SystemStandardOutputLogger.stdErrInfo("Unable to attach with regular provider:");
                SystemStandardOutputLogger.printStackTrace(e1);
            }
        }
    }

    @Deprecated
    public static void attach(String pid, String agentArgs) {
        ElasticApmAttacher.attachWithFallback(AgentJarFileHolder.INSTANCE.agentJarFile, pid, agentArgs);
    }

    public static File getBundledAgentJarFile() {
        return AgentJarFileHolder.INSTANCE.agentJarFile;
    }

    private static enum AgentJarFileHolder {
        INSTANCE;

        final File agentJarFile = AgentJarFileHolder.getAgentJarFile();

        private static File getAgentJarFile() {
            if (ElasticApmAttacher.class.getResource("/elastic-apm-agent.jar") != null) {
                return ResourceExtractionUtil.extractResourceToTempDirectory("elastic-apm-agent.jar", "elastic-apm-agent", ".jar").toFile();
            }
            throw new IllegalStateException("unable to get packaged agent within attacher jar.");
        }
    }
}

