/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Version INVALID = new Version(new int[0], "");
    private static final Pattern VERSION_REGEX = Pattern.compile("^(?<prefix>.*?)(?<version>(\\d+)(\\.\\d+)*)(?<suffix>.*?)$");
    private final int[] numbers;
    private final String suffix;

    public static Version of(String version) {
        Matcher matcher = VERSION_REGEX.matcher(version);
        if (!matcher.find()) {
            return INVALID;
        }
        String[] parts = matcher.group("version").split("\\.");
        int[] numbers = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            numbers[i] = Integer.parseInt(parts[i]);
        }
        String suffixTmp = matcher.group("suffix");
        if (suffixTmp == null) {
            suffixTmp = "";
        }
        String suffix = suffixTmp;
        return new Version(numbers, suffix);
    }

    private Version(int[] numbers, String suffix) {
        this.numbers = numbers;
        this.suffix = suffix;
    }

    public boolean hasSuffix() {
        return this.suffix.length() > 0;
    }

    public Version withoutSuffix() {
        return new Version(this.numbers, "");
    }

    @Override
    public int compareTo(Version another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.numbers.length ? this.numbers[i] : 0;
            int n = right = i < another.numbers.length ? another.numbers[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        if (this.suffix.isEmpty() || another.suffix.isEmpty()) {
            return another.suffix.compareTo(this.suffix);
        }
        return this.suffix.compareTo(another.suffix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numbers.length; ++i) {
            sb.append(this.numbers[i]);
            if (i >= this.numbers.length - 1) continue;
            sb.append('.');
        }
        sb.append(this.suffix);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Arrays.equals(this.numbers, version.numbers) && this.suffix.equals(version.suffix);
    }

    public int hashCode() {
        int result = Objects.hash(this.suffix);
        result = 31 * result + Arrays.hashCode(this.numbers);
        return result;
    }
}

