/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.graphics.Rect;
import android.view.View;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ViewabilityInfo;
import com.amazon.device.ads.ViewabilityOverlapCalculator;
import org.json.JSONException;
import org.json.JSONObject;

class ViewabilityChecker {
    private static final String LOGTAG = ViewabilityChecker.class.getSimpleName();
    static final String VIEWABLE_PERCENTAGE = "viewablePercentage";
    static final String X_POSITION_AD = "x";
    static final String Y_POSITION_AD = "y";
    static final String WIDTH_AD = "width";
    static final String HEIGHT_AD = "height";
    static final String IS_AD_ONSCREEN = "isAdOnScreen";
    static final String INSTRUMENTATION_URL = "instrumentationPixelUrl";
    private float adTotalArea;
    private final AdController adController;
    private final MobileAdsLogger logger;
    private View adView;
    private ViewabilityOverlapCalculator viewabilityOverlapCalculator;

    public ViewabilityChecker(AdController adController) {
        this(adController, new MobileAdsLoggerFactory(), new ViewabilityOverlapCalculator(adController));
    }

    ViewabilityChecker(AdController adController, MobileAdsLoggerFactory mobileAdsLoggerFactory, ViewabilityOverlapCalculator viewabilityOverlapCalculator) {
        this.adController = adController;
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(LOGTAG);
        if (this.adController == null) {
            throw new IllegalArgumentException("AdController is null");
        }
        this.viewabilityOverlapCalculator = viewabilityOverlapCalculator;
    }

    public ViewabilityInfo getViewabilityInfo() {
        boolean isAdOnScreen;
        float visibleArea = 0.0f;
        Rect visibleAdRect = new Rect();
        this.adView = this.adController.getAdContainer().getCurrentAdView();
        this.adTotalArea = this.adView == null ? 0.0f : (float)(this.adView.getWidth() * this.adView.getHeight());
        if ((double)this.adTotalArea == 0.0) {
            this.logger.w("AdView width and height not set");
            return null;
        }
        boolean isAdVisible = this.adView.getGlobalVisibleRect(visibleAdRect);
        boolean isAdShown = this.adView.isShown();
        boolean windowHasFocus = this.hasWindowFocus();
        boolean isAdTransparent = AndroidTargetUtils.isAdTransparent((View)this.adController.getAdContainer());
        if (isAdTransparent) {
            this.logger.forceLog(MobileAdsLogger.Level.WARN, "This ad view is transparent therefore it will not be considered viewable. Please ensure the ad view is completely opaque.", new Object[0]);
        }
        this.logger.d("IsAdVisible: %s, IsAdShown: %s, windowHasFocus: %s, IsAdTransparent: %s", isAdVisible, isAdShown, windowHasFocus, isAdTransparent);
        boolean bl = isAdOnScreen = isAdVisible && isAdShown && windowHasFocus && !isAdTransparent;
        if (isAdOnScreen) {
            if (this.adController.isModal()) {
                visibleArea = 100.0f;
            } else {
                long beforeTime = System.currentTimeMillis();
                visibleArea = this.viewabilityOverlapCalculator.calculateViewablePercentage(this.adView, visibleAdRect);
                long afterTime = System.currentTimeMillis();
                this.logger.d("Total computation time: %d", afterTime - beforeTime);
            }
        }
        if (visibleArea == 0.0f) {
            isAdOnScreen = false;
        }
        JSONObject jsonObject = this.getJSONObject(visibleArea, isAdOnScreen, this.adView);
        ViewabilityInfo viewabilityInfo = new ViewabilityInfo(isAdOnScreen, jsonObject);
        return viewabilityInfo;
    }

    private JSONObject getJSONObject(float visibleArea, boolean isAdOnScreen, View adView) {
        JSONObject jsonObject = new JSONObject();
        int[] location = new int[2];
        try {
            jsonObject.put(VIEWABLE_PERCENTAGE, (double)visibleArea);
            jsonObject.put(WIDTH_AD, adView.getWidth());
            jsonObject.put(HEIGHT_AD, adView.getHeight());
            if (isAdOnScreen) {
                this.adView.getLocationOnScreen(location);
            }
            jsonObject.put(X_POSITION_AD, location[0]);
            jsonObject.put(Y_POSITION_AD, location[1]);
        }
        catch (JSONException e) {
            this.logger.w("JSON Error occured %s", e.getMessage());
            return null;
        }
        return jsonObject;
    }

    private boolean hasWindowFocus() {
        View rootView = this.adController.getRootView();
        if (rootView == null) {
            return false;
        }
        return rootView.hasWindowFocus();
    }
}

