/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.SISGenerateDIDRequest;
import com.amazon.device.ads.SISRegisterEventRequest;
import com.amazon.device.ads.SISUpdateDeviceInfoRequest;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class SISRequest {
    private final String logTag;
    private final Metrics.MetricType callMetricType;
    private final String path;
    private final Configuration configuration;
    protected MobileAdsInfoStore mobileAdsInfoStore;
    protected final MobileAdsLogger logger;

    SISRequest(MobileAdsLoggerFactory mobileAdsLoggerFactory, String logTag, Metrics.MetricType callMetricType, String path, MobileAdsInfoStore mobileAdsInfoStore, Configuration configuration) {
        this.logTag = logTag;
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(this.logTag);
        this.callMetricType = callMetricType;
        this.path = path;
        this.mobileAdsInfoStore = mobileAdsInfoStore;
        this.configuration = configuration;
    }

    MobileAdsLogger getLogger() {
        return this.logger;
    }

    String getLogTag() {
        return this.logTag;
    }

    Metrics.MetricType getCallMetricType() {
        return this.callMetricType;
    }

    String getPath() {
        return this.path;
    }

    WebRequest.QueryStringParameters getQueryParameters() {
        WebRequest.QueryStringParameters queryStringParameters = new WebRequest.QueryStringParameters();
        queryStringParameters.putUrlEncoded("dt", this.mobileAdsInfoStore.getDeviceInfo().getDeviceType());
        queryStringParameters.putUrlEncoded("app", this.mobileAdsInfoStore.getRegistrationInfo().getAppName());
        queryStringParameters.putUrlEncoded("appId", this.mobileAdsInfoStore.getRegistrationInfo().getAppKey());
        queryStringParameters.putUrlEncoded("sdkVer", Version.getSDKVersion());
        queryStringParameters.putUrlEncoded("aud", this.configuration.getString(Configuration.ConfigOption.SIS_DOMAIN));
        queryStringParameters.putUnencoded("pkg", this.mobileAdsInfoStore.getAppInfo().getPackageInfoJSONString());
        return queryStringParameters;
    }

    abstract HashMap<String, String> getPostParameters();

    abstract void onResponseReceived(JSONObject var1);

    static enum SISDeviceRequestType {
        GENERATE_DID,
        UPDATE_DEVICE_INFO;

    }

    static class SISRequestFactory {
        SISRequestFactory() {
        }

        public SISDeviceRequest createDeviceRequest(SISDeviceRequestType requestType, AdvertisingIdentifier advertisingIdentifier) {
            switch (requestType) {
                case GENERATE_DID: {
                    return new SISGenerateDIDRequest(advertisingIdentifier);
                }
                case UPDATE_DEVICE_INFO: {
                    return new SISUpdateDeviceInfoRequest(advertisingIdentifier);
                }
            }
            throw new IllegalArgumentException("SISRequestType " + (Object)((Object)requestType) + " is not a SISDeviceRequest");
        }

        public SISRegisterEventRequest createRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents) {
            return new SISRegisterEventRequest(advertisingIdentifierInfo, appEvents);
        }
    }
}

