/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.provider.MediaStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class GraphicsUtils {
    private static final String LOGTAG = GraphicsUtils.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    GraphicsUtils() {
    }

    public Bitmap createBitmapImage(InputStream inputStream) {
        if (inputStream != null) {
            int bufferSize = 32768;
            inputStream = new BufferedInputStream(inputStream, 32768);
            inputStream.mark(32768);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.logger.e("IOException while trying to close the input stream.");
            }
            return bitmap;
        }
        return null;
    }

    public String insertImageInMediaStore(Context context, Bitmap bitmap, String name, String description) {
        return MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)name, (String)description);
    }
}

