/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.NumberUtils;

public class AdSize {
    private static final String LOGTAG = AdSize.class.getSimpleName();
    public static final AdSize SIZE_320x50 = new AdSize(320, 50);
    public static final AdSize SIZE_300x250 = new AdSize(300, 250);
    public static final AdSize SIZE_600x90 = new AdSize(600, 90);
    public static final AdSize SIZE_728x90 = new AdSize(728, 90);
    public static final AdSize SIZE_1024x50 = new AdSize(1024, 50);
    public static final AdSize SIZE_AUTO = new AdSize(SizeType.AUTO);
    public static final AdSize SIZE_AUTO_NO_SCALE = new AdSize(SizeType.AUTO, Scaling.NO_UPSCALE);
    static final AdSize SIZE_INTERSTITIAL = new AdSize(SizeType.INTERSTITIAL, Modality.MODAL);
    static final AdSize SIZE_MODELESS_INTERSTITIAL = new AdSize(SizeType.INTERSTITIAL);
    private int width;
    private int height;
    private int gravity = 17;
    private SizeType type = SizeType.EXPLICIT;
    private Modality modality = Modality.MODELESS;
    private Scaling scaling = Scaling.CAN_UPSCALE;
    private int maxWidth;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    public AdSize(int width, int height) {
        this.initialize(width, height);
    }

    AdSize(String width, String height) {
        int parsedWidth = NumberUtils.parseInt(width, 0);
        int parsedHeight = NumberUtils.parseInt(height, 0);
        this.initialize(parsedWidth, parsedHeight);
    }

    AdSize(SizeType type) {
        this.type = type;
    }

    AdSize(SizeType type, Modality modality) {
        this(type);
        this.modality = modality;
    }

    AdSize(SizeType type, Scaling scaling) {
        this(type);
        this.scaling = scaling;
    }

    private AdSize deepClone() {
        AdSize adSize = new AdSize(this.type);
        adSize.width = this.width;
        adSize.height = this.height;
        adSize.gravity = this.gravity;
        adSize.modality = this.modality;
        adSize.scaling = this.scaling;
        adSize.maxWidth = this.maxWidth;
        return adSize;
    }

    private void initialize(int width, int height) {
        if (width <= 0 || height <= 0) {
            String msg = "The width and height must be positive integers.";
            this.logger.e(msg);
            throw new IllegalArgumentException(msg);
        }
        this.width = width;
        this.height = height;
        this.type = SizeType.EXPLICIT;
    }

    public AdSize newGravity(int gravity) {
        AdSize adSize = this.deepClone();
        adSize.gravity = gravity;
        return adSize;
    }

    public int getGravity() {
        return this.gravity;
    }

    public String toString() {
        String sizeString = null;
        switch (this.type) {
            case EXPLICIT: {
                sizeString = AdSize.getAsSizeString(this.width, this.height);
                break;
            }
            case AUTO: {
                sizeString = "auto";
                break;
            }
            case INTERSTITIAL: {
                sizeString = "interstitial";
            }
        }
        return sizeString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdSize) {
            AdSize other = (AdSize)obj;
            if (this.type.equals((Object)other.type)) {
                if (this.type.equals((Object)SizeType.EXPLICIT) && (this.width != other.width || this.height != other.height)) {
                    return false;
                }
                return this.gravity == other.gravity && this.maxWidth == other.maxWidth && this.scaling == other.scaling && this.modality == other.modality;
            }
        }
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isAuto() {
        return this.type == SizeType.AUTO;
    }

    boolean isModal() {
        return Modality.MODAL.equals((Object)this.modality);
    }

    SizeType getSizeType() {
        return this.type;
    }

    public boolean canUpscale() {
        return Scaling.CAN_UPSCALE.equals((Object)this.scaling);
    }

    public AdSize disableScaling() {
        AdSize adSize = this.deepClone();
        adSize.scaling = Scaling.NO_UPSCALE;
        return adSize;
    }

    AdSize newMaxWidth(int maxWidth) {
        AdSize adSize = this.deepClone();
        adSize.maxWidth = maxWidth;
        return adSize;
    }

    int getMaxWidth() {
        return this.maxWidth;
    }

    static String getAsSizeString(int w, int h) {
        return Integer.toString(w) + "x" + Integer.toString(h);
    }

    private static enum Scaling {
        CAN_UPSCALE,
        NO_UPSCALE;

    }

    private static enum Modality {
        MODAL,
        MODELESS;

    }

    static enum SizeType {
        EXPLICIT,
        AUTO,
        INTERSTITIAL;

    }
}

