/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class ViewabilityOverlapCalculator {
    private static final String LOGTAG = ViewabilityOverlapCalculator.class.getSimpleName();
    private View rootView;
    private final MobileAdsLogger logger;
    private final AdController adController;
    private Rect visibleAdRectangle;

    public ViewabilityOverlapCalculator(AdController adController) {
        this(adController, new MobileAdsLoggerFactory());
    }

    ViewabilityOverlapCalculator(AdController adController, MobileAdsLoggerFactory mobileAdsLoggerFactory) {
        this.adController = adController;
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(LOGTAG);
    }

    public float calculateViewablePercentage(View adView, Rect visibleAdRect) {
        int totalArea = adView.getWidth() * adView.getHeight();
        if ((float)totalArea == 0.0f) {
            return 0.0f;
        }
        this.visibleAdRectangle = visibleAdRect;
        if (this.rootView == null) {
            this.rootView = this.adController.getRootView();
        }
        ArrayList<Rectangle> overlappingRectangles = new ArrayList<Rectangle>();
        ViewGroup adContainer = (ViewGroup)adView.getParent();
        if (adContainer == null) {
            this.logger.d("AdContainer is null");
            return 0.0f;
        }
        int viewIndex = adContainer.indexOfChild(adView);
        this.findOverlapppingViews(new Rectangle(visibleAdRect), viewIndex + 1, adContainer, overlappingRectangles, true);
        int hiddenArea = this.getTotalAreaOfSetOfRectangles(overlappingRectangles);
        int totalVisibleArea = visibleAdRect.width() * visibleAdRect.height();
        int visibleArea = totalVisibleArea - hiddenArea;
        this.logger.d("Visible area: %s , Total area: %s", visibleArea, totalArea);
        float percentage = (float)visibleArea / (float)totalArea * 100.0f;
        return percentage;
    }

    @TargetApi(value=11)
    private void findOverlapppingViews(Rectangle adRectangle, int index, ViewGroup viewParent, List<Rectangle> overlappingRectangles, boolean goUp) {
        if (viewParent != null && goUp && AndroidTargetUtils.isAdTransparent((View)viewParent)) {
            overlappingRectangles.add(new Rectangle(this.visibleAdRectangle));
            return;
        }
        for (int i = index; i < viewParent.getChildCount(); ++i) {
            Rectangle childRectangle;
            boolean isChildListView;
            View childView = viewParent.getChildAt(i);
            boolean bl = isChildListView = childView != null && childView instanceof ListView;
            if (!childView.isShown() || AndroidTargetUtils.isAtLeastAndroidAPI(11) && childView.getAlpha() == 0.0f || !(childRectangle = this.getViewRectangle(childView)).intersect(adRectangle)) continue;
            if (!isChildListView && childView instanceof ViewGroup) {
                this.findOverlapppingViews(adRectangle, 0, (ViewGroup)childView, overlappingRectangles, false);
                continue;
            }
            this.logger.d("Overlap found with View: %s", childView);
            overlappingRectangles.add(childRectangle);
        }
        if (!goUp) {
            return;
        }
        if (this.rootView.equals(viewParent)) {
            return;
        }
        ViewParent parentParent = viewParent.getParent();
        if (parentParent == null || !(parentParent instanceof ViewGroup)) {
            return;
        }
        ViewGroup parent = (ViewGroup)parentParent;
        int parentIndex = parent.indexOfChild((View)viewParent);
        this.findOverlapppingViews(adRectangle, parentIndex + 1, parent, overlappingRectangles, true);
    }

    private Rectangle getViewRectangle(View adView) {
        int[] location = new int[2];
        adView.getLocationOnScreen(location);
        return new Rectangle(location[0], location[1], adView.getWidth() + location[0], adView.getHeight() + location[1]);
    }

    protected int getTotalAreaOfSetOfRectangles(List<Rectangle> rectangles) {
        int[] x = new int[rectangles.size() * 2];
        for (int i = 0; i < rectangles.size(); ++i) {
            Rectangle rectangle = rectangles.get(i);
            int index = i * 2;
            x[index] = rectangle.getLeft();
            x[index + 1] = rectangle.getRight();
        }
        Arrays.sort(x);
        Collections.sort(rectangles);
        int totalArea = 0;
        for (int i = 0; i < x.length - 1; ++i) {
            int lowX = x[i];
            int highX = x[i + 1];
            if (lowX == highX) continue;
            Range xRange = new Range(lowX, highX);
            List<Range> yRanges = this.getYRanges(xRange, rectangles);
            totalArea += this.computeArea(xRange, yRanges);
        }
        return totalArea;
    }

    private int computeArea(Range xRange, List<Range> yRanges) {
        int area = 0;
        int width = xRange.high - xRange.low;
        for (int i = 0; i < yRanges.size(); ++i) {
            Range yRange = yRanges.get(i);
            area += (yRange.high - yRange.low) * width;
        }
        return area;
    }

    protected List<Range> getYRanges(Range xRange, List<Rectangle> rectangles) {
        ArrayList<Range> yRanges = new ArrayList<Range>();
        Range candidate = null;
        for (int i = 0; i < rectangles.size(); ++i) {
            Rectangle rect = rectangles.get(i);
            if (xRange.low >= rect.getRight() || xRange.high <= rect.getLeft()) continue;
            Range yRange = new Range(rect.getTop(), rect.getBottom());
            if (candidate == null) {
                candidate = yRange;
                yRanges.add(yRange);
                continue;
            }
            if (yRange.isOverlap(candidate)) {
                candidate.mergeRange(yRange);
                continue;
            }
            candidate = yRange;
            yRanges.add(yRange);
        }
        return yRanges;
    }

    class Rectangle
    implements Comparable<Rectangle> {
        private final Rect rect;

        public Rectangle(Rect rect) {
            this.rect = rect;
        }

        public Rectangle(int left, int top, int right, int bottom) {
            this.rect = new Rect();
            this.rect.left = left;
            this.rect.top = top;
            this.rect.right = right;
            this.rect.bottom = bottom;
        }

        public int getLeft() {
            return this.rect.left;
        }

        public int getTop() {
            return this.rect.top;
        }

        public int getRight() {
            return this.rect.right;
        }

        public int getBottom() {
            return this.rect.bottom;
        }

        public boolean intersect(Rectangle rectangle) {
            if (this.rect.width() == 0 || this.rect.height() == 0) {
                return false;
            }
            boolean intersect = this.rect.intersect(rectangle.rect);
            return intersect;
        }

        public boolean contains(Rectangle rectangle) {
            return this.rect.contains(rectangle.rect);
        }

        public int getWidth() {
            return this.rect.width();
        }

        public int getHeight() {
            return this.rect.height();
        }

        @Override
        public int compareTo(Rectangle other) {
            if (this.rect.top < other.rect.top) {
                return 1;
            }
            if (this.rect.top == other.rect.top) {
                return 0;
            }
            return -1;
        }
    }

    class Range {
        int low;
        int high;

        public Range(int low, int high) {
            this.low = low;
            this.high = high;
        }

        public boolean isOverlap(Range range) {
            return this.low <= range.high && this.high >= range.low;
        }

        public void mergeRange(Range range) {
            this.low = this.low > range.low ? range.low : this.low;
            this.high = this.high < range.high ? range.high : this.high;
        }
    }
}

