/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.AppEventRegistrationHandler;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

class SISRegisterEventRequest
extends SISRequest {
    private static final String LOGTAG = "SISRegisterEventRequest";
    private static final Metrics.MetricType CALL_METRIC_TYPE = Metrics.MetricType.SIS_LATENCY_REGISTER_EVENT;
    private static final String PATH = "/register_event";
    private final AdvertisingIdentifier.Info advertisingIdentifierInfo;
    private final AppEventRegistrationHandler appEventRegistrationHandler;
    private final JSONArray appEvents;

    public SISRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents) {
        this(advertisingIdentifierInfo, appEvents, AppEventRegistrationHandler.getInstance(), new MobileAdsLoggerFactory(), MobileAdsInfoStore.getInstance(), Configuration.getInstance());
    }

    SISRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents, AppEventRegistrationHandler appEventRegistrationHandler, MobileAdsLoggerFactory mobileAdsLoggerFactory, MobileAdsInfoStore mobileAdsInfoStore, Configuration configuration) {
        super(mobileAdsLoggerFactory, LOGTAG, CALL_METRIC_TYPE, PATH, mobileAdsInfoStore, configuration);
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        this.appEvents = appEvents;
        this.appEventRegistrationHandler = appEventRegistrationHandler;
    }

    @Override
    public WebRequest.QueryStringParameters getQueryParameters() {
        WebRequest.QueryStringParameters queryStringParameters = super.getQueryParameters();
        queryStringParameters.putUrlEncoded("adId", this.advertisingIdentifierInfo.getSISDeviceIdentifier());
        return queryStringParameters;
    }

    @Override
    public HashMap<String, String> getPostParameters() {
        HashMap<String, String> eventsMap = new HashMap<String, String>();
        eventsMap.put("events", this.appEvents.toString());
        return eventsMap;
    }

    @Override
    public void onResponseReceived(JSONObject payload) {
        int statusCode = JSONUtils.getIntegerFromJSON(payload, "rcode", 0);
        if (statusCode == 1) {
            this.logger.d("Application events registered successfully.");
            this.appEventRegistrationHandler.onAppEventsRegistered();
        } else {
            this.logger.d("Application events not registered. rcode:" + statusCode);
        }
    }
}

