/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.SharedPreferences;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class GDPRInfo {
    private static final String LOGTAG = GDPRInfo.class.getSimpleName();
    private MobileAdsLogger logger;
    private SharedPreferences prefs;

    public GDPRInfo(SharedPreferences prefs) {
        this.prefs = prefs;
        this.logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    }

    public JSONObject toJsonObject() {
        return this.toJsonObject(this.prefs);
    }

    public JSONObject toJsonObject(SharedPreferences prefs) {
        String gdprSubject = prefs.getString("IABConsent_SubjectToGDPR", null);
        String apsSubject = prefs.getString("aps_gdpr_pub_pref_li", null);
        String gdprConsent = prefs.getString("IABConsent_ConsentString", null);
        JSONObject reply = null;
        try {
            if (gdprConsent != null) {
                reply = new JSONObject();
                reply.put("c", (Object)gdprConsent);
            }
            if (gdprSubject != null) {
                gdprSubject = gdprSubject.trim();
                if (reply == null) {
                    reply = new JSONObject();
                }
                reply.put("e", (Object)gdprSubject);
            }
            if (apsSubject != null) {
                apsSubject = apsSubject.trim();
                if (reply == null) {
                    reply = new JSONObject();
                }
                reply.put("i", (Object)apsSubject);
            }
        }
        catch (JSONException ex) {
            this.logger.w("INVALID JSON formed for GDPR clause");
            reply = null;
        }
        return reply;
    }
}

