/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXParameter;
import com.amazon.device.ads.AdvertisingIdentifierAAXParameter;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DirectedIdAAXParameter;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SHA1UDIDAAXParameter;
import com.amazon.device.ads.SISDeviceIdentifierAAXParameter;
import com.amazon.device.ads.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AAXParameterGroupParameter {
    private static final String LOG_TAG = AAXParameterGroupParameter.class.getSimpleName();
    private final String key;
    private final String debugName;
    protected final DebugProperties debugProperties;
    private final MobileAdsLogger logger;
    static final AdvertisingIdentifierAAXParameter ADVERTISING_IDENTIFIER = new AdvertisingIdentifierAAXParameter();
    static final SISDeviceIdentifierAAXParameter SIS_DEVICE_IDENTIFIER = new SISDeviceIdentifierAAXParameter();
    static final SHA1UDIDAAXParameter SHA1_UDID = new SHA1UDIDAAXParameter();
    static final DirectedIdAAXParameter DIRECTED_ID = new DirectedIdAAXParameter();

    AAXParameterGroupParameter(DebugProperties debugProperties, String key, String debugName, MobileAdsLoggerFactory loggerFactory) {
        this.debugProperties = debugProperties;
        this.key = key;
        this.debugName = debugName;
        this.logger = loggerFactory.createMobileAdsLogger(LOG_TAG);
    }

    boolean evaluate(AAXParameter.ParameterData parameterData, JSONObject jsonObject) {
        String paramValue = this.debugProperties.getDebugPropertyAsString(this.debugName, this.getDerivedValue(parameterData));
        return this.putIntoJSON(jsonObject, this.key, paramValue);
    }

    protected abstract String getDerivedValue(AAXParameter.ParameterData var1);

    protected boolean putIntoJSON(JSONObject json, String key, String value) {
        if (!StringUtils.isNullOrEmpty(value)) {
            try {
                json.put(key, (Object)value);
                return true;
            }
            catch (JSONException e) {
                this.logger.d("Could not add parameter to JSON %s: %s", key, value);
            }
        }
        return false;
    }
}

