/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXParameter;
import com.amazon.device.ads.AAXParameterGroupParameter;
import com.amazon.device.ads.AdvertisingIdentifierAAXParameter;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DirectedIdAAXParameter;
import com.amazon.device.ads.LogcatLogger;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.SHA1UDIDAAXParameter;
import com.amazon.device.ads.SISDeviceIdentifierAAXParameter;
import com.amazon.device.ads.StringUtils;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AAXParameterGroup {
    public static final UserIdAAXParameterGroup USER_ID = new UserIdAAXParameterGroup();
    public static final PublisherExtraParametersAAXParameterGroup PUBLISHER_EXTRA_PARAMETERS = new PublisherExtraParametersAAXParameterGroup();

    AAXParameterGroup() {
    }

    public abstract void evaluate(AAXParameter.ParameterData var1, JSONObject var2);

    static final class PublisherExtraParametersAAXParameterGroup
    extends AAXParameterGroup {
        private static final String LOGTAG = PublisherExtraParametersAAXParameterGroup.class.getSimpleName();
        private final MobileAdsLogger logger;
        private final DebugProperties debugProperties;

        public PublisherExtraParametersAAXParameterGroup() {
            this(new MobileAdsLogger(new LogcatLogger()).withLogTag(LOGTAG), DebugProperties.getInstance());
        }

        PublisherExtraParametersAAXParameterGroup(MobileAdsLogger logger, DebugProperties debugProperties) {
            this.logger = logger;
            this.debugProperties = debugProperties;
        }

        @Override
        public void evaluate(AAXParameter.ParameterData parameterData, JSONObject jsonObject) {
            JSONObject pjObject = this.processPJInputOrDebugParameterIfPresent(parameterData);
            if (pjObject == null) {
                JSONArray keywords;
                pjObject = new JSONObject();
                JSONArray asins = AAXParameter.PUBLISHER_ASINS.getValueDoNotRemove(parameterData);
                if (asins != null && asins.length() > 0) {
                    try {
                        pjObject.put("asins", (Object)asins.join(",").replaceAll("\"", ""));
                    }
                    catch (JSONException e) {
                        this.logger.e("Error putting asins into pj, continuing but not including asins with pj", new Object[]{e});
                    }
                }
                if ((keywords = (JSONArray)AAXParameter.PUBLISHER_KEYWORDS.getValueDoNotRemove(parameterData)) != null && keywords.length() > 0) {
                    try {
                        pjObject.put("tk", (Object)keywords);
                        pjObject.put("q", (Object)keywords.join(" ").replaceAll("\"", ""));
                    }
                    catch (JSONException e) {
                        this.logger.e("Error putting either tk or q into pj, continuing but not including keywords with pj", new Object[]{e});
                    }
                }
            }
            if (pjObject.length() > 0) {
                try {
                    jsonObject.put("pj", (Object)pjObject);
                }
                catch (JSONException e) {
                    this.logger.e("Error storing pj created from asins and keywords, not including pj in request", new Object[]{e});
                }
            }
        }

        private JSONObject processPJInputOrDebugParameterIfPresent(AAXParameter.ParameterData parameterData) {
            String pjValue;
            JSONObject pjObject = null;
            Map<String, String> advancedOptions = parameterData.getInternalAdvancedOptions();
            if (advancedOptions != null && advancedOptions.containsKey("pj") && !StringUtils.isNullOrEmpty(pjValue = advancedOptions.remove("pj"))) {
                try {
                    pjObject = new JSONObject(pjValue);
                }
                catch (JSONException e) {
                    this.logger.e("Error creating JSON object for pj from advanced option. Ignoring advanced option.", new Object[]{e});
                }
            }
            return this.debugProperties.getDebugPropertyAsJSONObject("debug.pj", pjObject);
        }
    }

    static final class UserIdAAXParameterGroup
    extends AAXParameterGroup {
        private final DirectedIdAAXParameter directedIdParameter;
        private final AdvertisingIdentifierAAXParameter idfaParameter;
        private final SISDeviceIdentifierAAXParameter adIdParameter;
        private final SHA1UDIDAAXParameter sha1udidParameter;

        UserIdAAXParameterGroup() {
            this(AAXParameterGroupParameter.DIRECTED_ID, AAXParameterGroupParameter.ADVERTISING_IDENTIFIER, AAXParameterGroupParameter.SIS_DEVICE_IDENTIFIER, AAXParameterGroupParameter.SHA1_UDID);
        }

        UserIdAAXParameterGroup(DirectedIdAAXParameter directedIdParameter, AdvertisingIdentifierAAXParameter idfaParameter, SISDeviceIdentifierAAXParameter adIdParameter, SHA1UDIDAAXParameter sha1udidParameter) {
            this.directedIdParameter = directedIdParameter;
            this.idfaParameter = idfaParameter;
            this.adIdParameter = adIdParameter;
            this.sha1udidParameter = sha1udidParameter;
        }

        @Override
        public void evaluate(AAXParameter.ParameterData parameterData, JSONObject jsonObject) {
            boolean directedId = this.directedIdParameter.evaluate(parameterData, jsonObject);
            if (directedId) {
                return;
            }
            boolean idfa = this.idfaParameter.evaluate(parameterData, jsonObject);
            if (!idfa) {
                this.sha1udidParameter.evaluate(parameterData, jsonObject);
            }
            this.adIdParameter.evaluate(parameterData, jsonObject);
        }
    }
}

