/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import java.util.HashSet;
import java.util.Set;

enum AAXCreative {
    HTML(1007),
    MRAID1(1016),
    MRAID2(1017),
    INTERSTITIAL(1008),
    CAN_PLAY_AUDIO1(1001),
    CAN_PLAY_AUDIO2(1002),
    CAN_EXPAND1(1003),
    CAN_EXPAND2(1004),
    CAN_PLAY_VIDEO(1014),
    VIDEO_INTERSTITIAL(1030),
    REQUIRES_TRANSPARENCY(1031);

    private final int id;
    private static final HashSet<AAXCreative> primaryCreativeTypes;

    private AAXCreative(int id2) {
        this.id = id2;
    }

    public int getId() {
        return this.id;
    }

    public static boolean containsPrimaryCreativeType(Set<AAXCreative> creativeTypes) {
        for (AAXCreative creativeType : primaryCreativeTypes) {
            if (!creativeTypes.contains((Object)creativeType)) continue;
            return true;
        }
        return false;
    }

    public static AAXCreative getCreativeType(int id2) {
        switch (id2) {
            case 1007: {
                return HTML;
            }
            case 1016: {
                return MRAID1;
            }
            case 1017: {
                return MRAID2;
            }
            case 1008: {
                return INTERSTITIAL;
            }
            case 1030: {
                return VIDEO_INTERSTITIAL;
            }
            case 1003: {
                return CAN_EXPAND1;
            }
            case 1004: {
                return CAN_EXPAND2;
            }
            case 1001: {
                return CAN_PLAY_AUDIO1;
            }
            case 1002: {
                return CAN_PLAY_AUDIO2;
            }
            case 1014: {
                return CAN_PLAY_VIDEO;
            }
            case 1031: {
                return REQUIRES_TRANSPARENCY;
            }
        }
        return null;
    }

    static AAXCreative getTopCreative(Set<AAXCreative> creatives) {
        if (creatives.contains((Object)MRAID2)) {
            return MRAID2;
        }
        if (creatives.contains((Object)MRAID1)) {
            return MRAID1;
        }
        if (creatives.contains((Object)HTML)) {
            return HTML;
        }
        return null;
    }

    static {
        primaryCreativeTypes = new HashSet();
        primaryCreativeTypes.add(HTML);
        primaryCreativeTypes.add(MRAID1);
        primaryCreativeTypes.add(MRAID2);
        primaryCreativeTypes.add(INTERSTITIAL);
        primaryCreativeTypes.add(VIDEO_INTERSTITIAL);
    }
}

