/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.StringUtils;
import java.io.InputStream;
import org.json.JSONObject;

class ResponseReader {
    private static final String LOGTAG = ResponseReader.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private final InputStream stream;
    private boolean enableLog = false;

    ResponseReader(InputStream stream) {
        this.stream = stream;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public void enableLog(boolean enabled) {
        this.enableLog = enabled;
    }

    public void setExternalLogTag(String externalLogTag) {
        if (externalLogTag == null) {
            this.logger.withLogTag(LOGTAG);
        } else {
            this.logger.withLogTag(LOGTAG + " " + externalLogTag);
        }
    }

    public String readAsString() {
        String response = StringUtils.readStringFromInputStream(this.stream);
        if (this.enableLog) {
            this.logger.d("Response Body: %s", response);
        }
        return response;
    }

    public JSONObject readAsJSON() {
        return JSONUtils.getJSONObjectFromString(this.readAsString());
    }
}

