/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.NumberUtils;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.PreferredMarketplaceRetriever;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.SystemTime;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebRequestUserId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class Configuration {
    private static final String LOGTAG = Configuration.class.getSimpleName();
    private static final String AAX_PROD_US_HOSTNAME = "mads.amazon-adsystem.com";
    private static final String AAX_MSDK_CONFIG_ENDPOINT = "/msdk/getConfig";
    protected static final int MAX_NO_RETRY_TTL = 300000;
    protected static final int MAX_CONFIG_TTL = 172800000;
    protected static final String CONFIG_TTL = "config-ttl";
    protected static final String CONFIG_LASTFETCHTIME = "config-lastFetchTime";
    protected static final String CONFIG_APP_DEFINED_MARKETPLACE = "config-appDefinedMarketplace";
    protected static final String CONFIG_VERSION_NAME = "configVersion";
    protected static final int CURRENT_CONFIG_VERSION = 4;
    private static Configuration instance = new Configuration();
    private String appDefinedMarketplace = null;
    private boolean isAppDefinedMarketplaceSet = false;
    private final List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>(5);
    private final AtomicBoolean isFetching = new AtomicBoolean(false);
    private Boolean lastTestModeValue = null;
    private boolean isFirstParty = false;
    private PreferredMarketplaceRetriever pfmRetriever = new PreferredMarketplaceRetriever.NullPreferredMarketplaceRetriever();
    private final MobileAdsLogger logger;
    private final PermissionChecker permissionChecker;
    private final WebRequest.WebRequestFactory webRequestFactory;
    private final DebugProperties debugProperties;
    private final Settings settings;
    private final MobileAdsInfoStore infoStore;
    private final SystemTime systemTime;
    private final Metrics metrics;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final WebRequestUserId webRequestUserId;

    protected Configuration() {
        this(new MobileAdsLoggerFactory(), new PermissionChecker(), new WebRequest.WebRequestFactory(), DebugProperties.getInstance(), Settings.getInstance(), MobileAdsInfoStore.getInstance(), new SystemTime(), Metrics.getInstance(), ThreadUtils.getThreadRunner(), new WebRequestUserId());
    }

    Configuration(MobileAdsLoggerFactory loggerFactory, PermissionChecker permissionChecker, WebRequest.WebRequestFactory webRequestFactory, DebugProperties debugProperties, Settings settings, MobileAdsInfoStore infoStore, SystemTime systemTime, Metrics metrics, ThreadUtils.ThreadRunner threadRunner, WebRequestUserId webRequestUserId) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.permissionChecker = permissionChecker;
        this.webRequestFactory = webRequestFactory;
        this.debugProperties = debugProperties;
        this.settings = settings;
        this.infoStore = infoStore;
        this.systemTime = systemTime;
        this.metrics = metrics;
        this.threadRunner = threadRunner;
        this.webRequestUserId = webRequestUserId;
    }

    public static final Configuration getInstance() {
        return instance;
    }

    public void setAppDefinedMarketplace(String appDefinedMarketplace) {
        this.appDefinedMarketplace = appDefinedMarketplace;
        this.isAppDefinedMarketplaceSet = true;
    }

    public void setIsFirstParty(boolean isFirstParty) {
        this.isFirstParty = isFirstParty;
    }

    boolean isFirstParty() {
        return this.isFirstParty;
    }

    public boolean hasValue(ConfigOption configOption) {
        return !StringUtils.isNullOrWhiteSpace(this.getString(configOption));
    }

    public String getString(ConfigOption configOption) {
        return this.settings.getString(configOption.getSettingsName(), null);
    }

    public String getStringWithDefault(ConfigOption configOption, String defaultValue) {
        return this.settings.getString(configOption.getSettingsName(), defaultValue);
    }

    public boolean getBoolean(ConfigOption configOption) {
        return this.getBooleanWithDefault(configOption, false);
    }

    public boolean getBooleanWithDefault(ConfigOption configOption, boolean defaultValue) {
        return this.settings.getBoolean(configOption.getSettingsName(), defaultValue);
    }

    public int getInt(ConfigOption configOption) {
        return this.getIntWithDefault(configOption, 0);
    }

    public int getIntWithDefault(ConfigOption configOption, int defaultValue) {
        return this.settings.getInt(configOption.getSettingsName(), defaultValue);
    }

    public long getLong(ConfigOption configOption) {
        return this.getLongWithDefault(configOption, 0L);
    }

    public long getLongWithDefault(ConfigOption configOption, long defaultValue) {
        return this.settings.getLong(configOption.getSettingsName(), defaultValue);
    }

    public JSONObject getJSONObject(ConfigOption configOption) {
        return this.getJSONObjectWithDefault(configOption, null);
    }

    public JSONObject getJSONObjectWithDefault(ConfigOption configOption, JSONObject defaultValue) {
        return this.settings.getJSONObject(configOption.getSettingsName(), defaultValue);
    }

    protected boolean shouldFetch() {
        long ttl;
        if (this.hasAppDefinedMarketplaceChanged()) {
            return true;
        }
        if (this.settings.getInt(CONFIG_VERSION_NAME, 0) != 4) {
            return true;
        }
        long lastFetchTime = this.settings.getLong(CONFIG_LASTFETCHTIME, 0L);
        if (lastFetchTime == 0L) {
            this.logger.d("No configuration found. A new configuration will be retrieved.");
            return true;
        }
        long currentTime = this.systemTime.currentTimeMillis();
        if (currentTime - lastFetchTime > (ttl = this.settings.getLong(CONFIG_TTL, 172800000L))) {
            this.logger.d("The configuration has expired. A new configuration will be retrieved.");
            return true;
        }
        long identifyUserTime = this.settings.getWrittenLong("amzn-ad-iu-last-checkin", 0L);
        if (identifyUserTime - lastFetchTime > 0L) {
            this.logger.d("A new user has been identified. A new configuration will be retrieved.");
            return true;
        }
        if (this.lastTestModeValue != null && this.lastTestModeValue.booleanValue() != this.settings.getBoolean("testingEnabled", false)) {
            this.logger.d("The testing mode has changed. A new configuration will be retrieved.");
            return true;
        }
        return this.debugProperties.getDebugPropertyAsBoolean("debug.shouldFetchConfig", false) != false;
    }

    private boolean hasAppDefinedMarketplaceChanged() {
        String storedAppDefinedMarketplace = this.settings.getString(CONFIG_APP_DEFINED_MARKETPLACE, null);
        boolean appDefinedMarketplaceChanged = false;
        if (this.isAppDefinedMarketplaceSet) {
            this.isAppDefinedMarketplaceSet = false;
            if (this.appDefinedMarketplace != null && !this.appDefinedMarketplace.equals(storedAppDefinedMarketplace)) {
                this.settings.putLongWithNoFlush(CONFIG_LASTFETCHTIME, 0L);
                this.settings.putStringWithNoFlush(CONFIG_APP_DEFINED_MARKETPLACE, this.appDefinedMarketplace);
                this.settings.flush();
                this.infoStore.getRegistrationInfo().requestNewSISDeviceIdentifier();
                this.logger.d("New application-defined marketplace set. A new configuration will be retrieved.");
                appDefinedMarketplaceChanged = true;
            } else if (storedAppDefinedMarketplace != null && this.appDefinedMarketplace == null) {
                this.settings.remove(CONFIG_APP_DEFINED_MARKETPLACE);
                this.infoStore.getRegistrationInfo().requestNewSISDeviceIdentifier();
                this.logger.d("Application-defined marketplace removed. A new configuration will be retrieved.");
                appDefinedMarketplaceChanged = true;
            }
        }
        return appDefinedMarketplaceChanged;
    }

    protected boolean isFetching() {
        return this.isFetching.get();
    }

    protected void setIsFetching(boolean isFetching) {
        this.isFetching.set(isFetching);
    }

    public synchronized void queueConfigurationListener(ConfigurationListener listener) {
        this.queueConfigurationListener(listener, true);
    }

    public synchronized void queueConfigurationListener(ConfigurationListener listener, boolean allowFetch) {
        if (this.isFetching()) {
            this.listeners.add(listener);
        } else if (this.shouldFetch()) {
            this.listeners.add(listener);
            if (allowFetch) {
                this.logger.d("Starting configuration fetching...");
                this.setIsFetching(true);
                this.beginFetch();
            }
        } else {
            listener.onConfigurationReady();
        }
    }

    protected void beginFetch() {
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                Configuration.this.fetchConfigurationOnBackgroundThread();
            }
        }, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.BACKGROUND_THREAD);
    }

    protected synchronized void onFetchSuccess() {
        ConfigurationListener[] toCall;
        this.setIsFetching(false);
        for (ConfigurationListener listener : toCall = this.getAndClearListeners()) {
            listener.onConfigurationReady();
        }
    }

    protected synchronized void onFetchFailure() {
        ConfigurationListener[] toCall;
        this.metrics.getMetricsCollector().incrementMetric(Metrics.MetricType.AAX_CONFIG_DOWNLOAD_FAILED);
        this.setIsFetching(false);
        for (ConfigurationListener listener : toCall = this.getAndClearListeners()) {
            listener.onConfigurationFailure();
        }
    }

    protected synchronized ConfigurationListener[] getAndClearListeners() {
        ConfigurationListener[] toCall = new ConfigurationListener[this.listeners.size()];
        toCall = this.listeners.toArray(toCall);
        this.listeners.clear();
        return toCall;
    }

    protected ConfigOption[] getConfigOptions() {
        return ConfigOption.configOptions;
    }

    protected void setLastTestModeValue(boolean testMode) {
        this.lastTestModeValue = testMode;
    }

    protected void fetchConfigurationOnBackgroundThread() {
        long ttl;
        WebRequest.WebResponse webResponse;
        this.logger.d("In configuration fetcher background thread.");
        boolean passesInternetPermissionCheck = this.permissionChecker.hasInternetPermission(this.infoStore.getApplicationContext());
        if (!passesInternetPermissionCheck) {
            this.logger.e("Network task cannot commence because the INTERNET permission is missing from the app's manifest.");
            this.onFetchFailure();
            return;
        }
        WebRequest webRequest = this.createWebRequest();
        if (webRequest == null) {
            this.onFetchFailure();
            return;
        }
        try {
            webResponse = webRequest.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            this.onFetchFailure();
            return;
        }
        JSONObject json = webResponse.getResponseReader().readAsJSON();
        try {
            for (ConfigOption configOption : this.getConfigOptions()) {
                if (json.isNull(configOption.getResponseKey())) {
                    if (!configOption.getAllowEmpty()) {
                        throw new Exception("The configuration value for " + configOption.getResponseKey() + " must be present and not null.");
                    }
                    this.settings.removeWithNoFlush(configOption.getSettingsName());
                    continue;
                }
                this.writeSettingFromConfigOption(configOption, json);
            }
            if (!json.isNull(ConfigOption.DEBUG_PROPERTIES.getResponseKey())) {
                this.debugProperties.overwriteDebugProperties(json.getJSONObject(ConfigOption.DEBUG_PROPERTIES.getResponseKey()));
            } else {
                this.settings.removeWithNoFlush(ConfigOption.DEBUG_PROPERTIES.getSettingsName());
                this.debugProperties.clearDebugProperties();
            }
            if (json.isNull("ttl")) {
                throw new Exception("The configuration value must be present and not null.");
            }
            ttl = NumberUtils.convertToMillisecondsFromSeconds(json.getInt("ttl"));
        }
        catch (JSONException e) {
            this.logger.e("Unable to parse JSON response: %s", e.getMessage());
            this.onFetchFailure();
            return;
        }
        catch (Exception e) {
            this.logger.e("Unexpected error during parsing: %s", e.getMessage());
            this.onFetchFailure();
            return;
        }
        ttl = ttl > 172800000L ? 172800000L : ttl;
        this.settings.putLongWithNoFlush(CONFIG_TTL, ttl);
        this.settings.putLongWithNoFlush(CONFIG_LASTFETCHTIME, this.systemTime.currentTimeMillis());
        this.settings.putIntWithNoFlush(CONFIG_VERSION_NAME, 4);
        this.settings.flush();
        this.logger.d("Configuration fetched and saved.");
        this.onFetchSuccess();
    }

    private void writeSettingFromConfigOption(ConfigOption configOption, JSONObject json) throws Exception {
        if (configOption.getDataType().equals(String.class)) {
            String value = json.getString(configOption.getResponseKey());
            if (!configOption.getAllowEmpty() && StringUtils.isNullOrWhiteSpace(value)) {
                throw new IllegalArgumentException("The configuration value must not be empty or contain only white spaces.");
            }
            this.settings.putStringWithNoFlush(configOption.getSettingsName(), value);
        } else if (configOption.getDataType().equals(Boolean.class)) {
            boolean value = json.getBoolean(configOption.getResponseKey());
            this.settings.putBooleanWithNoFlush(configOption.getSettingsName(), value);
        } else if (configOption.getDataType().equals(Integer.class)) {
            int value = json.getInt(configOption.getResponseKey());
            this.settings.putIntWithNoFlush(configOption.getSettingsName(), value);
        } else if (configOption.getDataType().equals(Long.class)) {
            long value = json.getLong(configOption.getResponseKey());
            this.settings.putLongWithNoFlush(configOption.getSettingsName(), value);
        } else if (configOption.getDataType().equals(JSONObject.class)) {
            JSONObject value = json.getJSONObject(configOption.getResponseKey());
            this.settings.putJSONObjectWithNoFlush(configOption.getSettingsName(), value);
        } else {
            throw new IllegalArgumentException("Undefined configuration option type.");
        }
    }

    protected WebRequest createWebRequest() {
        WebRequest request = this.webRequestFactory.createJSONGetWebRequest();
        request.setExternalLogTag(LOGTAG);
        request.enableLog(true);
        request.setHost(this.debugProperties.getDebugPropertyAsString("debug.aaxConfigHostname", AAX_PROD_US_HOSTNAME));
        request.setPath(AAX_MSDK_CONFIG_ENDPOINT);
        request.setMetricsCollector(this.metrics.getMetricsCollector());
        request.setServiceCallLatencyMetric(Metrics.MetricType.AAX_CONFIG_DOWNLOAD_LATENCY);
        request.setUseSecure(this.debugProperties.getDebugPropertyAsBoolean("debug.aaxConfigUseSecure", true));
        RegistrationInfo registrationInfo = this.infoStore.getRegistrationInfo();
        DeviceInfo deviceInfo = this.infoStore.getDeviceInfo();
        request.putUnencodedQueryParameter("appId", registrationInfo.getAppKey());
        request.putUnencodedQueryParameter("dinfo", deviceInfo.getDInfoProperty().toString());
        request.putUnencodedQueryParameter("sdkVer", Version.getSDKVersion());
        request.putUnencodedQueryParameter("fp", Boolean.toString(this.isFirstParty));
        request.putUnencodedQueryParameter("mkt", this.settings.getString(CONFIG_APP_DEFINED_MARKETPLACE, null));
        request.putUnencodedQueryParameter("pfm", this.getPreferredMarketplace());
        boolean testingEnabled = this.settings.getBoolean("testingEnabled", false);
        this.setLastTestModeValue(testingEnabled);
        if (testingEnabled) {
            request.putUnencodedQueryParameter("testMode", "true");
        }
        request.setAdditionalQueryParamsString(this.debugProperties.getDebugPropertyAsString("debug.aaxConfigParams", null));
        if (!this.webRequestUserId.populateWebRequestUserId(request)) {
            return null;
        }
        return request;
    }

    public void setPreferredMarketplaceRetriever(PreferredMarketplaceRetriever pfmRetriever) {
        this.pfmRetriever = pfmRetriever;
    }

    PreferredMarketplaceRetriever getPreferredMarketplaceRetriever() {
        return this.pfmRetriever;
    }

    private String getPreferredMarketplace() {
        return this.pfmRetriever.retrievePreferredMarketplace(MobileAdsInfoStore.getInstance().getApplicationContext());
    }

    static interface ConfigurationListener {
        public void onConfigurationReady();

        public void onConfigurationFailure();
    }

    public static class ConfigOption {
        public static final ConfigOption AAX_HOSTNAME = new ConfigOption("config-aaxHostname", String.class, "aaxHostname");
        public static final ConfigOption AD_RESOURCE_PATH = new ConfigOption("config-adResourcePath", String.class, "adResourcePath");
        public static final ConfigOption SIS_URL = new ConfigOption("config-sisURL", String.class, "sisURL");
        public static final ConfigOption AD_PREF_URL = new ConfigOption("config-adPrefURL", String.class, "adPrefURL");
        public static final ConfigOption MADS_HOSTNAME = new ConfigOption("config-madsHostname", String.class, "madsHostname", true);
        public static final ConfigOption SIS_DOMAIN = new ConfigOption("config-sisDomain", String.class, "sisDomain");
        public static final ConfigOption SEND_GEO = new ConfigOption("config-sendGeo", Boolean.class, "sendGeo");
        public static final ConfigOption TRUNCATE_LAT_LON = new ConfigOption("config-truncateLatLon", Boolean.class, "truncateLatLon");
        public static final ConfigOption WHITELISTED_CUSTOMER = new ConfigOption("config-whitelistedCustomer", Boolean.class, "whitelistedCustomer");
        public static final ConfigOption IDENTIFY_USER_INTERVAL = new ConfigOption("config-identifyUserInterval", Long.class, "identifyUserInterval");
        public static final ConfigOption IDENTIFY_USER_SESSION_INTERVAL = new ConfigOption("config-identifyUserSessionIdInterval", Long.class, "identifyUserSessionIdInterval", true);
        public static final ConfigOption VIEWABLE_JAVASCRIPT_URL = new ConfigOption("config-viewableJavascriptCDNURL", String.class, "viewableJavascriptCDNURL");
        public static final ConfigOption VIEWABLE_JS_VERSION_CONFIG = new ConfigOption("config-viewableJSVersionConfig", Integer.class, "viewableJSVersion");
        public static final ConfigOption VIEWABLE_INTERVAL = new ConfigOption("config-viewableInterval", Long.class, "viewableInterval", true);
        public static final ConfigOption DEBUG_PROPERTIES = new ConfigOption("config-debugProperties", JSONObject.class, "debugProperties", true);
        public static final ConfigOption BASE_URL = new ConfigOption("config-baseURL", String.class, "baseURL", true);
        public static final ConfigOption[] configOptions = new ConfigOption[]{AAX_HOSTNAME, AD_RESOURCE_PATH, SIS_URL, AD_PREF_URL, MADS_HOSTNAME, SIS_DOMAIN, SEND_GEO, TRUNCATE_LAT_LON, WHITELISTED_CUSTOMER, IDENTIFY_USER_INTERVAL, IDENTIFY_USER_SESSION_INTERVAL, VIEWABLE_JAVASCRIPT_URL, VIEWABLE_JS_VERSION_CONFIG, DEBUG_PROPERTIES, VIEWABLE_INTERVAL, BASE_URL};
        private final String settingsName;
        private final String responseKey;
        private final Class<?> dataType;
        private final boolean allowEmpty;

        protected ConfigOption(String settingsName, Class<?> dataType, String responseKey) {
            this(settingsName, dataType, responseKey, false);
        }

        protected ConfigOption(String settingsName, Class<?> dataType, String responseKey, boolean allowEmpty) {
            this.settingsName = settingsName;
            this.responseKey = responseKey;
            this.dataType = dataType;
            this.allowEmpty = allowEmpty;
        }

        private String getSettingsName() {
            return this.settingsName;
        }

        String getResponseKey() {
            return this.responseKey;
        }

        Class<?> getDataType() {
            return this.dataType;
        }

        boolean getAllowEmpty() {
            return this.allowEmpty;
        }
    }
}

