/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXCreative;
import com.amazon.device.ads.AdSDKBridgeFactory;
import com.amazon.device.ads.AmazonAdSDKBridgeFactory;
import com.amazon.device.ads.AmazonViewableAdSDKBridgeFactory;
import com.amazon.device.ads.MraidAdSDKBridgeFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class BridgeSelector {
    private static BridgeSelector instance = new BridgeSelector();
    private HashMap<AAXCreative, HashSet<AdSDKBridgeFactory>> bridgesForCT;
    private HashMap<String, HashSet<AdSDKBridgeFactory>> bridgesForPattern;
    private HashMap<String, Pattern> patterns;
    private HashMap<String, HashSet<AdSDKBridgeFactory>> bridgesForResourcePattern;
    private final AmazonViewableAdSDKBridgeFactory amazonAdSDKViewableBridgeFactory;

    public static BridgeSelector getInstance() {
        return instance;
    }

    BridgeSelector() {
        this(new AmazonViewableAdSDKBridgeFactory());
        this.initialize();
    }

    BridgeSelector(AmazonViewableAdSDKBridgeFactory amazonViewableAdSDKBridgeFactory) {
        this.amazonAdSDKViewableBridgeFactory = amazonViewableAdSDKBridgeFactory;
    }

    void initialize() {
        this.bridgesForCT = new HashMap();
        this.bridgesForPattern = new HashMap();
        this.patterns = new HashMap();
        this.bridgesForResourcePattern = new HashMap();
        AmazonAdSDKBridgeFactory amazonAdSDKBridgeFactory = new AmazonAdSDKBridgeFactory();
        this.addBridgeFactoryForScript("amazon.js", amazonAdSDKBridgeFactory);
        MraidAdSDKBridgeFactory mraidBridgeFactory = new MraidAdSDKBridgeFactory();
        this.addBridgeFactory(AAXCreative.MRAID1, mraidBridgeFactory);
        this.addBridgeFactory(AAXCreative.MRAID2, mraidBridgeFactory);
        this.addBridgeFactory(AAXCreative.INTERSTITIAL, mraidBridgeFactory);
        this.addBridgeFactoryForScript("mraid.js", mraidBridgeFactory);
    }

    public void addBridgeFactory(AAXCreative creativeType, AdSDKBridgeFactory bridgeFactory) {
        HashSet<AdSDKBridgeFactory> bridges = this.bridgesForCT.get((Object)creativeType);
        if (bridges == null) {
            bridges = new HashSet();
            this.bridgesForCT.put(creativeType, bridges);
        }
        bridges.add(bridgeFactory);
    }

    public void addBridgeFactoryForScript(String filename, AdSDKBridgeFactory bridgeFactory) {
        this.addBridgeFactoryForHtmlScriptTag(filename, bridgeFactory);
        this.addBridgeFactoryForResourceLoad(filename, bridgeFactory);
    }

    public void addBridgeFactoryForHtmlScriptTag(String filename, AdSDKBridgeFactory bridgeFactory) {
        String format = "<[Ss][Cc][Rr][Ii][Pp][Tt](\\s[^>]*\\s|\\s)[Ss][Rr][Cc]\\s*=\\s*[\"']%s[\"']";
        String regex = String.format("<[Ss][Cc][Rr][Ii][Pp][Tt](\\s[^>]*\\s|\\s)[Ss][Rr][Cc]\\s*=\\s*[\"']%s[\"']", filename);
        HashSet<AdSDKBridgeFactory> bridges = this.bridgesForPattern.get(regex);
        if (bridges == null) {
            bridges = new HashSet();
            this.bridgesForPattern.put(regex, bridges);
        }
        bridges.add(bridgeFactory);
    }

    public void addBridgeFactoryForResourceLoad(String filename, AdSDKBridgeFactory bridgeFactory) {
        HashSet<AdSDKBridgeFactory> bridges = this.bridgesForResourcePattern.get(filename);
        if (bridges == null) {
            bridges = new HashSet();
            this.bridgesForResourcePattern.put(filename, bridges);
        }
        bridges.add(bridgeFactory);
        bridges.add(this.amazonAdSDKViewableBridgeFactory);
    }

    public Set<AdSDKBridgeFactory> getBridgeFactories(AAXCreative creativeType) {
        HashSet<AdSDKBridgeFactory> bridges = this.bridgesForCT.get((Object)creativeType);
        if (bridges == null) {
            bridges = new HashSet<AdSDKBridgeFactory>();
        }
        bridges.add(this.amazonAdSDKViewableBridgeFactory);
        return bridges;
    }

    public Set<AdSDKBridgeFactory> getBridgeFactories(String input) {
        HashSet<AdSDKBridgeFactory> bridges = new HashSet<AdSDKBridgeFactory>();
        for (String regex : this.bridgesForPattern.keySet()) {
            Pattern p = this.getPattern(regex);
            Matcher m = p.matcher(input);
            if (!m.find()) continue;
            bridges.addAll((Collection<AdSDKBridgeFactory>)this.bridgesForPattern.get(regex));
        }
        bridges.add(this.amazonAdSDKViewableBridgeFactory);
        return bridges;
    }

    public Set<AdSDKBridgeFactory> getBridgeFactoriesForResourceLoad(String input) {
        HashSet<AdSDKBridgeFactory> bridges = new HashSet<AdSDKBridgeFactory>();
        for (String filename : this.bridgesForResourcePattern.keySet()) {
            boolean matches = false;
            if (input.endsWith(filename)) {
                char symbol;
                int index = input.length() - filename.length() - 1;
                matches = index < 0 ? true : !((symbol = input.charAt(index)) >= 'A' && symbol <= 'z' || symbol >= '0' && symbol <= '9');
            }
            if (!matches) continue;
            bridges.addAll((Collection<AdSDKBridgeFactory>)this.bridgesForResourcePattern.get(filename));
        }
        bridges.add(this.amazonAdSDKViewableBridgeFactory);
        return bridges;
    }

    private Pattern getPattern(String regex) {
        Pattern pattern = this.patterns.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            this.patterns.put(regex, pattern);
        }
        return pattern;
    }
}

