/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.amazon.device.ads.GooglePlayServices;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;

public class AmazonFireServicesAdapter {
    public static final int FIREOS_ADTRACKING_NOT_LIMITED = 0;
    private static final String LOGTAG = AmazonFireServicesAdapter.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    public static AmazonFireServicesAdapter newAdapter() {
        return new AmazonFireServicesAdapter();
    }

    private AmazonFireServicesAdapter() {
    }

    public GooglePlayServices.AdvertisingInfo getAdvertisingIdentifierInfo() {
        String advertisingID = null;
        boolean limitAdTracking = false;
        try {
            Context adRegistrationContext = MobileAdsInfoStore.getInstance().getApplicationContext();
            ContentResolver contentResolver = adRegistrationContext.getContentResolver();
            int limitedAdTrackingCode = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking");
            advertisingID = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
            this.logger.v("Fire Id retrieved : %s", advertisingID);
            if (limitedAdTrackingCode != 0) {
                this.logger.v("Fire Device does not allow ad tracking : %s", advertisingID);
                limitAdTracking = true;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            this.logger.v(" Advertising setting not found on this device : %s" + e.getLocalizedMessage());
            return new GooglePlayServices.AdvertisingInfo();
        }
        catch (Exception e) {
            this.logger.v(" Attempt to retrieve fireID failed. Reason : %s " + e.getLocalizedMessage());
            return new GooglePlayServices.AdvertisingInfo();
        }
        GooglePlayServices.AdvertisingInfo advertisingInfo = new GooglePlayServices.AdvertisingInfo();
        advertisingInfo.setAdvertisingIdentifier(advertisingID);
        advertisingInfo.setLimitAdTrackingEnabled(limitAdTracking);
        return advertisingInfo;
    }
}

