/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.ConnectionInfo;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsInfoStore;
import java.util.HashSet;

class AdUtils {
    public static final String REQUIRED_ACTIVITY = "com.amazon.device.ads.AdActivity";
    private static AdUtilsExecutor executor = new AdUtilsExecutor();

    private AdUtils() {
    }

    static boolean checkDefinedActivities(Context context) {
        return executor.checkDefinedActivities(context);
    }

    static void setConnectionMetrics(ConnectionInfo connectionInfo, MetricsCollector metricsCollector) {
        executor.setConnectionMetrics(connectionInfo, metricsCollector);
    }

    public static double getViewportInitialScale(double defaultScale) {
        return executor.getViewportInitialScale(defaultScale);
    }

    public static double calculateScalingMultiplier(int absoluteAdWidth, int absoluteAdHeight, int absoluteWindowWidth, int absoluteWindowHeight) {
        return executor.calculateScalingMultiplier(absoluteAdWidth, absoluteAdHeight, absoluteWindowWidth, absoluteWindowHeight);
    }

    public static int pixelToDeviceIndependentPixel(int px) {
        return executor.pixelToDeviceIndependentPixel(px);
    }

    public static int deviceIndependentPixelToPixel(int dp) {
        return executor.deviceIndependentPixelToPixel(dp);
    }

    public static float getScalingFactorAsFloat() {
        return executor.getScalingFactorAsFloat();
    }

    static class AdUtilsExecutor {
        private final HashSet<String> requiredActivities = new HashSet();
        private boolean hasRequiredActivities = false;

        AdUtilsExecutor() {
            this.requiredActivities.add(AdUtils.REQUIRED_ACTIVITY);
        }

        boolean checkDefinedActivities(Context context) {
            if (this.hasRequiredActivities) {
                return true;
            }
            HashSet<String> activities = new HashSet<String>();
            try {
                String path = context.getPackageCodePath();
                PackageManager pManager = context.getPackageManager();
                PackageInfo info = pManager.getPackageArchiveInfo(path, 1);
                for (ActivityInfo a : info.activities) {
                    activities.add(a.name);
                }
                this.hasRequiredActivities = activities.containsAll(this.requiredActivities);
                return this.hasRequiredActivities;
            }
            catch (Exception exception) {
                this.hasRequiredActivities = true;
                return true;
            }
        }

        void setConnectionMetrics(ConnectionInfo connectionInfo, MetricsCollector metricsCollector) {
            DeviceInfo deviceInfo;
            if (connectionInfo != null) {
                if (connectionInfo.isWiFi()) {
                    metricsCollector.incrementMetric(Metrics.MetricType.WIFI_PRESENT);
                } else {
                    metricsCollector.setMetricString(Metrics.MetricType.CONNECTION_TYPE, connectionInfo.getConnectionType());
                }
            }
            if ((deviceInfo = MobileAdsInfoStore.getInstance().getDeviceInfo()).getCarrier() != null) {
                metricsCollector.setMetricString(Metrics.MetricType.CARRIER_NAME, deviceInfo.getCarrier());
            }
        }

        double getViewportInitialScale(double defaultScale) {
            return AndroidTargetUtils.isAtLeastAndroidAPI(19) ? 1.0 : defaultScale;
        }

        double calculateScalingMultiplier(int absoluteAdWidth, int absoluteAdHeight, int absoluteWindowWidth, int absoluteWindowHeight) {
            double heightRatio = (double)absoluteWindowHeight / (double)absoluteAdHeight;
            double widthRatio = (double)absoluteWindowWidth / (double)absoluteAdWidth;
            double multiplier = (heightRatio < widthRatio || widthRatio == 0.0) && heightRatio != 0.0 ? heightRatio : widthRatio;
            return multiplier == 0.0 ? 1.0 : multiplier;
        }

        int pixelToDeviceIndependentPixel(int px) {
            return (int)((float)px / this.getScalingFactorAsFloat());
        }

        int deviceIndependentPixelToPixel(int dp) {
            return (int)(dp == -1 ? (float)dp : (float)dp * this.getScalingFactorAsFloat());
        }

        float getScalingFactorAsFloat() {
            return MobileAdsInfoStore.getInstance().getDeviceInfo().getScalingFactorAsFloat();
        }
    }
}

