/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.graphics.Rect;
import com.amazon.device.ads.ActionCode;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.OnAdEventCommand;
import com.amazon.device.ads.OnAdExpiredCommand;
import com.amazon.device.ads.OnAdReceivedCommand;
import com.amazon.device.ads.OnAdResizedCommand;
import com.amazon.device.ads.OnSpecialUrlClickedCommand;
import com.amazon.device.ads.ThreadUtils;

class AdListenerExecutor {
    private static final String LOGTAG = AdListenerExecutor.class.getSimpleName();
    private final AdListener adListener;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final MobileAdsLogger logger;
    private OnAdEventCommand onAdEventCommand;
    private OnAdResizedCommand onAdResizedCommand;
    private OnAdReceivedCommand onAdReceivedCommand;
    private OnAdExpiredCommand onAdExpiredCommand;
    private OnSpecialUrlClickedCommand onSpecialUrlClickedCommand;

    public AdListenerExecutor(AdListener adListener, MobileAdsLoggerFactory loggerFactory) {
        this(adListener, ThreadUtils.getThreadRunner(), loggerFactory);
    }

    AdListenerExecutor(AdListener adListener, ThreadUtils.ThreadRunner threadRunner, MobileAdsLoggerFactory loggerFactory) {
        this.adListener = adListener;
        this.threadRunner = threadRunner;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
    }

    AdListener getAdListener() {
        return this.adListener;
    }

    public void onAdLoaded(final Ad ad, final AdProperties adProperties) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdListenerExecutor.this.getAdListener().onAdLoaded(ad, adProperties);
            }
        };
        this.execute(runnable);
    }

    public void onAdFailedToLoad(final Ad ad, final AdError adError) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdListenerExecutor.this.getAdListener().onAdFailedToLoad(ad, adError);
            }
        };
        this.execute(runnable);
    }

    public void onAdExpanded(final Ad ad) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdListenerExecutor.this.getAdListener().onAdExpanded(ad);
            }
        };
        this.execute(runnable);
    }

    public void onAdCollapsed(final Ad ad) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdListenerExecutor.this.getAdListener().onAdCollapsed(ad);
            }
        };
        this.execute(runnable);
    }

    public void onAdDismissed(final Ad ad) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdListenerExecutor.this.getAdListener().onAdDismissed(ad);
            }
        };
        this.execute(runnable);
    }

    public void onAdResized(Ad ad, Rect positionOnScreen) {
        if (this.onAdResizedCommand == null) {
            this.logger.d("Ad listener called - Ad Resized.");
        } else {
            this.onAdResizedCommand.onAdResized(ad, positionOnScreen);
        }
    }

    public void onAdExpired(Ad ad) {
        if (this.onAdExpiredCommand == null) {
            this.logger.d("Ad listener called - Ad Expired.");
        } else {
            this.onAdExpiredCommand.onAdExpired(ad);
        }
    }

    public void onSpecialUrlClicked(Ad ad, String url) {
        if (this.onSpecialUrlClickedCommand == null) {
            this.logger.d("Ad listener called - Special Url Clicked.");
        } else {
            this.onSpecialUrlClickedCommand.onSpecialUrlClicked(ad, url);
        }
    }

    public ActionCode onAdReceived(Ad ad, AdData adData) {
        if (this.onAdReceivedCommand == null) {
            this.logger.d("Ad listener called - Ad Received.");
            return ActionCode.DISPLAY;
        }
        return this.onAdReceivedCommand.onAdReceived(ad, adData);
    }

    public void onAdEvent(AdEvent adEvent) {
        if (this.onAdEventCommand == null) {
            this.logger.d("Ad listener called - Ad Event: " + adEvent);
        } else {
            this.onAdEventCommand.onAdEvent(adEvent);
        }
    }

    protected void execute(Runnable runnable) {
        this.threadRunner.execute(runnable, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    public void setOnAdEventCommand(OnAdEventCommand onAdEventCommand) {
        this.onAdEventCommand = onAdEventCommand;
    }

    public void setOnAdResizedCommand(OnAdResizedCommand onAdResizedCommand) {
        this.onAdResizedCommand = onAdResizedCommand;
    }

    public void setOnAdExpiredCommand(OnAdExpiredCommand onAdExpiredCommand) {
        this.onAdExpiredCommand = onAdExpiredCommand;
    }

    public void setOnSpecialUrlClickedCommand(OnSpecialUrlClickedCommand onSpecialUrlClickedCommand) {
        this.onSpecialUrlClickedCommand = onSpecialUrlClickedCommand;
    }

    public void setOnAdReceivedCommand(OnAdReceivedCommand onAdReceivedCommand) {
        this.onAdReceivedCommand = onAdReceivedCommand;
    }
}

