/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.location.Location;
import com.amazon.device.ads.AdLocation;
import com.amazon.device.ads.AdRequest;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Parsers;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.Version;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AAXParameter<T> {
    private static final String LOGTAG = AAXParameter.class.getSimpleName();
    private final String name;
    private final String debugName;
    static final AAXParameter<String> APP_KEY = new AppKeyParameter();
    static final AAXParameter<String> CHANNEL = new StringParameter("c", "debug.channel");
    static final PublisherKeywordsParameter PUBLISHER_KEYWORDS = new PublisherKeywordsParameter();
    static final AAXParameter<JSONArray> PUBLISHER_ASINS = new JSONArrayParameter("pa", "debug.pa");
    static final AAXParameter<String> USER_AGENT = new UserAgentParameter();
    static final AAXParameter<String> SDK_VERSION = new SDKVersionParameter();
    static final AAXParameter<String> GEOLOCATION = new GeoLocationParameter();
    static final AAXParameter<JSONObject> DEVICE_INFO = new DeviceInfoParameter();
    static final AAXParameter<JSONObject> PACKAGE_INFO = new PackageInfoParameter();
    static final AAXParameter<Boolean> TEST = new TestParameter();
    static final AAXParameter<JSONArray> SLOTS = new JSONArrayParameter("slots", "debug.slots");
    static final AAXParameter<Boolean> OPT_OUT = new OptOutParameter();
    static final AAXParameter<String> SIZE = new SizeParameter();
    static final AAXParameter<String> PAGE_TYPE = new StringParameter("pt", "debug.pt");
    static final AAXParameter<String> SLOT = new SlotParameter();
    static final AAXParameter<String> SLOT_POSITION = new StringParameter("sp", "debug.sp");
    static final AAXParameter<String> MAX_SIZE = new MaxSizeParameter();
    static final AAXParameter<Integer> SLOT_ID = new SlotIdParameter();
    static final AAXParameter<Long> FLOOR_PRICE = new FloorPriceParameter();
    static final AAXParameter<JSONArray> SUPPORTED_MEDIA_TYPES = new SupportedMediaTypesParameter();
    static final AAXParameter<JSONObject> VIDEO_OPTIONS = new VideoOptionsParameter();

    AAXParameter(String name, String debugName) {
        this.name = name;
        this.debugName = debugName;
    }

    String getName() {
        return this.name;
    }

    protected String getDebugName() {
        return this.debugName;
    }

    protected boolean hasDebugPropertiesValue() {
        return DebugProperties.getInstance().containsDebugProperty(this.debugName);
    }

    T getValueDoNotRemove(ParameterData parameterData) {
        return this.getValueHelper(parameterData, false);
    }

    T getValue(ParameterData parameterData) {
        return this.getValueHelper(parameterData, true);
    }

    private T getValueHelper(ParameterData parameterData, boolean isDestructive) {
        Object value = null;
        if (this.hasDebugPropertiesValue()) {
            value = this.getFromDebugProperties();
        }
        if (parameterData.advancedOptions != null) {
            String advancedOption = isDestructive ? (String)parameterData.advancedOptions.remove(this.name) : (String)parameterData.advancedOptions.get(this.name);
            if (value == null && !StringUtils.isNullOrEmpty(advancedOption)) {
                value = this.parseFromString(advancedOption);
            }
        }
        if (value == null) {
            value = this.getDerivedValue(parameterData);
        }
        if ((value = this.applyPostParameterProcessing(value, parameterData)) instanceof String && StringUtils.isNullOrWhiteSpace(value)) {
            value = null;
        }
        return value;
    }

    protected T getDerivedValue(ParameterData parameterData) {
        return null;
    }

    protected T applyPostParameterProcessing(T value, ParameterData parameterData) {
        return value;
    }

    protected abstract T parseFromString(String var1);

    protected abstract T getFromDebugProperties();

    private static class VideoAdsEnabledChecker {
        private final ParameterData parameterData;

        public VideoAdsEnabledChecker(ParameterData parameterData) {
            this.parameterData = parameterData;
        }

        public boolean isVideoAdsEnabled() {
            if (!this.parameterData.loiSlot.getAdTargetingOptions().isVideoEnabledSettable()) {
                return false;
            }
            if (this.parameterData.advancedOptions.containsKey("enableVideoAds")) {
                String advancedOption = (String)this.parameterData.advancedOptions.remove("enableVideoAds");
                this.parameterData.temporaryOptions.put("enableVideoAds", advancedOption);
                return Boolean.parseBoolean(advancedOption);
            }
            if (this.parameterData.temporaryOptions.containsKey("enableVideoAds")) {
                return Boolean.parseBoolean((String)this.parameterData.temporaryOptions.get("enableVideoAds"));
            }
            return this.parameterData.loiSlot.getAdTargetingOptions().isVideoAdsEnabled();
        }
    }

    static class VideoOptionsParameter
    extends JSONObjectParameter {
        private static final int MINIMUM_DURATION_DEFAULT = 0;
        private static final int MAXIMUM_DURATION_DEFAULT = 30000;

        public VideoOptionsParameter() {
            super("video", "debug.videoOptions");
        }

        @Override
        protected JSONObject getDerivedValue(ParameterData parameterData) {
            JSONObject value = null;
            boolean videoAdsEnabled = new VideoAdsEnabledChecker(parameterData).isVideoAdsEnabled();
            if (videoAdsEnabled) {
                value = new JSONObject();
                int minVideoAdDuration = 0;
                if (parameterData.advancedOptions.containsKey("minVideoAdDuration")) {
                    Parsers.IntegerParser parseInt = new Parsers.IntegerParser().setDefaultValue(0).setParseErrorLogTag(LOGTAG).setParseErrorLogMessage("The minVideoAdDuration advanced option could not be parsed properly.");
                    minVideoAdDuration = parseInt.parse((String)parameterData.advancedOptions.remove("minVideoAdDuration"));
                }
                JSONUtils.put(value, "minAdDuration", minVideoAdDuration);
                int maxVideoAdDuration = 30000;
                if (parameterData.advancedOptions.containsKey("maxVideoAdDuration")) {
                    Parsers.IntegerParser parseInt = new Parsers.IntegerParser().setDefaultValue(30000).setParseErrorLogTag(LOGTAG).setParseErrorLogMessage("The maxVideoAdDuration advanced option could not be parsed properly.");
                    maxVideoAdDuration = parseInt.parse((String)parameterData.advancedOptions.remove("maxVideoAdDuration"));
                }
                JSONUtils.put(value, "maxAdDuration", maxVideoAdDuration);
            }
            return value;
        }
    }

    static class SupportedMediaTypesParameter
    extends JSONArrayParameter {
        public SupportedMediaTypesParameter() {
            super("supportedMediaTypes", "debug.supportedMediaTypes");
        }

        @Override
        protected JSONArray getDerivedValue(ParameterData parameterData) {
            JSONArray value = new JSONArray();
            this.addDisplay(parameterData, value);
            this.addVideo(parameterData, value);
            return value;
        }

        private void addDisplay(ParameterData parameterData, JSONArray json) {
            boolean displayAdsEnabled = parameterData.loiSlot.getAdTargetingOptions().isDisplayAdsEnabled();
            if (parameterData.advancedOptions.containsKey("enableDisplayAds")) {
                displayAdsEnabled = Boolean.parseBoolean((String)parameterData.advancedOptions.remove("enableDisplayAds"));
            }
            if (displayAdsEnabled) {
                json.put((Object)"DISPLAY");
            }
        }

        private void addVideo(ParameterData parameterData, JSONArray json) {
            boolean videoAdsEnabled = new VideoAdsEnabledChecker(parameterData).isVideoAdsEnabled();
            if (videoAdsEnabled) {
                json.put((Object)"VIDEO");
            }
        }
    }

    static class FloorPriceParameter
    extends LongParameter {
        FloorPriceParameter() {
            super("ec", "debug.ec");
        }

        @Override
        protected Long getDerivedValue(ParameterData parameterData) {
            if (parameterData.loiSlot.getAdTargetingOptions().hasFloorPrice()) {
                return parameterData.loiSlot.getAdTargetingOptions().getFloorPrice();
            }
            return null;
        }
    }

    static class SlotIdParameter
    extends IntegerParameter {
        SlotIdParameter() {
            super("slotId", "debug.slotId");
        }

        @Override
        protected Integer getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdSlot().getSlotNumber();
        }
    }

    static class MaxSizeParameter
    extends StringParameter {
        MaxSizeParameter() {
            super("mxsz", "debug.mxsz");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdSlot().getMaxSize();
        }
    }

    static class SlotParameter
    extends StringParameter {
        SlotParameter() {
            super("slot", "debug.slot");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.adRequest.getOrientation();
        }
    }

    static class SizeParameter
    extends StringParameter {
        SizeParameter() {
            super("sz", "debug.size");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdSlot().getRequestedAdSize().toString();
        }
    }

    static class OptOutParameter
    extends BooleanParameter {
        OptOutParameter() {
            super("oo", "debug.optOut");
        }

        @Override
        protected Boolean getDerivedValue(ParameterData parameterData) {
            if (parameterData.adRequest.getAdvertisingIdentifierInfo().hasAdvertisingIdentifier()) {
                return parameterData.adRequest.getAdvertisingIdentifierInfo().isLimitAdTrackingEnabled();
            }
            return null;
        }
    }

    static class TestParameter
    extends BooleanParameter {
        TestParameter() {
            super("isTest", "debug.test");
        }

        @Override
        protected Boolean getDerivedValue(ParameterData parameterData) {
            return Settings.getInstance().getBoolean("testingEnabled", null);
        }
    }

    static class PackageInfoParameter
    extends JSONObjectParameter {
        PackageInfoParameter() {
            super("pkg", "debug.pkg");
        }

        @Override
        protected JSONObject getDerivedValue(ParameterData parameterData) {
            return MobileAdsInfoStore.getInstance().getAppInfo().getPackageInfoJSON();
        }
    }

    static class DeviceInfoParameter
    extends JSONObjectParameter {
        DeviceInfoParameter() {
            super("dinfo", "debug.dinfo");
        }

        @Override
        protected JSONObject getDerivedValue(ParameterData parameterData) {
            return MobileAdsInfoStore.getInstance().getDeviceInfo().toJsonObject(parameterData.adRequest.getOrientation());
        }
    }

    static class GeoLocationParameter
    extends StringParameter {
        private final Configuration configuration;
        private final Context context;

        GeoLocationParameter() {
            this(Configuration.getInstance(), MobileAdsInfoStore.getInstance().getApplicationContext());
        }

        GeoLocationParameter(Configuration configuration, Context context) {
            super("geoloc", "debug.geoloc");
            this.configuration = configuration;
            this.context = context;
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            boolean configSendGeo = this.configuration.getBoolean(Configuration.ConfigOption.SEND_GEO);
            if (configSendGeo && parameterData.getAdRequest().getAdTargetingOptions().isGeoLocationEnabled()) {
                AdLocation adLocation = new AdLocation(this.context);
                Location location = adLocation.getLocation();
                return location == null ? null : location.getLatitude() + "," + location.getLongitude();
            }
            return null;
        }
    }

    static class SDKVersionParameter
    extends StringParameter {
        SDKVersionParameter() {
            super("adsdk", "debug.ver");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return Version.getSDKVersion();
        }
    }

    static class UserAgentParameter
    extends StringParameter {
        UserAgentParameter() {
            super("ua", "debug.ua");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return MobileAdsInfoStore.getInstance().getDeviceInfo().getUserAgentString();
        }
    }

    static class PublisherKeywordsParameter
    extends JSONArrayParameter {
        PublisherKeywordsParameter() {
            super("pk", "debug.pk");
        }

        @Override
        protected JSONArray applyPostParameterProcessing(JSONArray value, ParameterData parameterData) {
            HashSet<String> pks;
            if (value == null) {
                value = new JSONArray();
            }
            if (parameterData.adTargetingOptions != null && (pks = parameterData.adTargetingOptions.getInternalPublisherKeywords()) != null) {
                for (String pk : pks) {
                    value.put((Object)pk);
                }
            }
            return value;
        }
    }

    static class AppKeyParameter
    extends StringParameter {
        AppKeyParameter() {
            super("appId", "debug.appid");
        }

        @Override
        protected String getDerivedValue(ParameterData parameterData) {
            return MobileAdsInfoStore.getInstance().getRegistrationInfo().getAppKey();
        }
    }

    static class JSONObjectParameter
    extends AAXParameter<JSONObject> {
        private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(AAXParameter.access$100());

        JSONObjectParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected JSONObject parseFromString(String value) {
            try {
                return new JSONObject(value);
            }
            catch (JSONException e) {
                this.logger.e("Unable to parse the following value into a JSONObject: %s", this.getName());
                return null;
            }
        }

        @Override
        protected JSONObject getFromDebugProperties() {
            String debugProperty = DebugProperties.getInstance().getDebugPropertyAsString(this.getDebugName(), null);
            return this.parseFromString(debugProperty);
        }
    }

    static class JSONArrayParameter
    extends AAXParameter<JSONArray> {
        private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(AAXParameter.access$100());

        JSONArrayParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected JSONArray parseFromString(String value) {
            try {
                return new JSONArray(value);
            }
            catch (JSONException e) {
                this.logger.e("Unable to parse the following value into a JSONArray: %s", this.getName());
                return null;
            }
        }

        @Override
        protected JSONArray getFromDebugProperties() {
            String debugProperty = DebugProperties.getInstance().getDebugPropertyAsString(this.getDebugName(), null);
            return this.parseFromString(debugProperty);
        }
    }

    static class LongParameter
    extends AAXParameter<Long> {
        LongParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Long parseFromString(String value) {
            return Long.parseLong(value);
        }

        @Override
        protected Long getFromDebugProperties() {
            return DebugProperties.getInstance().getDebugPropertyAsLong(this.getDebugName(), null);
        }
    }

    static class IntegerParameter
    extends AAXParameter<Integer> {
        IntegerParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Integer parseFromString(String value) {
            return Integer.parseInt(value);
        }

        @Override
        protected Integer getFromDebugProperties() {
            return DebugProperties.getInstance().getDebugPropertyAsInteger(this.getDebugName(), null);
        }
    }

    static class BooleanParameter
    extends AAXParameter<Boolean> {
        BooleanParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Boolean parseFromString(String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        protected Boolean getFromDebugProperties() {
            return DebugProperties.getInstance().getDebugPropertyAsBoolean(this.getDebugName(), null);
        }
    }

    static class StringParameter
    extends AAXParameter<String> {
        StringParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected String parseFromString(String value) {
            return value;
        }

        @Override
        protected String getFromDebugProperties() {
            return DebugProperties.getInstance().getDebugPropertyAsString(this.getDebugName(), null);
        }
    }

    static class ParameterData {
        private AdRequest adRequest;
        private Map<String, String> advancedOptions;
        private AdRequest.LOISlot loiSlot;
        private AdTargetingOptions adTargetingOptions;
        private Map<String, String> temporaryOptions = new HashMap<String, String>();

        ParameterData setAdRequest(AdRequest adRequest) {
            this.adRequest = adRequest;
            return this;
        }

        ParameterData setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        Map<String, String> getInternalAdvancedOptions() {
            return this.advancedOptions;
        }

        ParameterData setLOISlot(AdRequest.LOISlot loiSlot) {
            this.loiSlot = loiSlot;
            return this;
        }

        AdRequest getAdRequest() {
            return this.adRequest;
        }

        ParameterData setAdTargetingOptions(AdTargetingOptions adTargetingOptions) {
            this.adTargetingOptions = adTargetingOptions;
            return this;
        }
    }
}

