/*
 * Decompiled with CFR 0.152.
 */
package com.ycbjie.notificationlib;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.widget.RemoteViews;

public class NotificationUtils
extends ContextWrapper {
    public static final String CHANNEL_ID = "default";
    private static final String CHANNEL_NAME = "Default_Channel";
    private NotificationManager mManager;
    private int[] flags;
    private boolean ongoing = false;
    private RemoteViews remoteViews = null;
    private PendingIntent intent = null;
    private String ticker = "";
    private int priority = 0;
    private boolean onlyAlertOnce = false;
    private long when = 0L;
    private Uri sound = null;
    private int defaults = 0;
    private long[] pattern = null;

    public NotificationUtils(Context base) {
        super(base);
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel();
        }
    }

    @TargetApi(value=26)
    private void createNotificationChannel() {
        NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 3);
        channel.canBypassDnd();
        channel.enableLights(true);
        channel.setLockscreenVisibility(-1);
        channel.setLightColor(-65536);
        channel.canShowBadge();
        channel.enableVibration(true);
        channel.getAudioAttributes();
        channel.getGroup();
        channel.setBypassDnd(true);
        channel.setVibrationPattern(new long[]{100L, 100L, 200L});
        channel.shouldShowLights();
        this.getManager().createNotificationChannel(channel);
    }

    public NotificationManager getManager() {
        if (this.mManager == null) {
            this.mManager = (NotificationManager)this.getSystemService("notification");
        }
        return this.mManager;
    }

    public void clearNotification() {
        this.getManager().cancelAll();
    }

    public void sendNotification(int notifyId, String title, String content, int icon) {
        Notification build;
        Notification.Builder builder;
        if (Build.VERSION.SDK_INT >= 26) {
            builder = this.getChannelNotification(title, content, icon);
            build = builder.build();
        } else {
            builder = this.getNotificationCompat(title, content, icon);
            build = builder.build();
        }
        if (this.flags != null && this.flags.length > 0) {
            for (int a = 0; a < this.flags.length; ++a) {
                build.flags |= this.flags[a];
            }
        }
        this.getManager().notify(notifyId, build);
    }

    public void sendNotificationCompat(int notifyId, String title, String content, int icon) {
        NotificationCompat.Builder builder = this.getNotificationCompat(title, content, icon);
        Notification build = builder.build();
        if (this.flags != null && this.flags.length > 0) {
            for (int a = 0; a < this.flags.length; ++a) {
                build.flags |= this.flags[a];
            }
        }
        this.getManager().notify(notifyId, build);
    }

    private NotificationCompat.Builder getNotificationCompat(String title, String content, int icon) {
        NotificationCompat.Builder builder;
        if (Build.VERSION.SDK_INT >= 26) {
            builder = new NotificationCompat.Builder(this.getApplicationContext(), CHANNEL_ID);
        } else {
            builder = new NotificationCompat.Builder(this.getApplicationContext());
            builder.setPriority(0);
        }
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)content);
        builder.setSmallIcon(icon);
        builder.setPriority(this.priority);
        builder.setOnlyAlertOnce(this.onlyAlertOnce);
        builder.setOngoing(this.ongoing);
        if (this.remoteViews != null) {
            builder.setContent(this.remoteViews);
        }
        if (this.intent != null) {
            builder.setContentIntent(this.intent);
        }
        if (this.ticker != null && this.ticker.length() > 0) {
            builder.setTicker((CharSequence)this.ticker);
        }
        if (this.when != 0L) {
            builder.setWhen(this.when);
        }
        if (this.sound != null) {
            builder.setSound(this.sound);
        }
        if (this.defaults != 0) {
            builder.setDefaults(this.defaults);
        }
        builder.setAutoCancel(true);
        return builder;
    }

    @RequiresApi(api=26)
    private Notification.Builder getChannelNotification(String title, String content, int icon) {
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext(), CHANNEL_ID);
        Notification.Builder notificationBuilder = builder.setContentTitle((CharSequence)title).setContentText((CharSequence)content).setSmallIcon(icon).setOngoing(this.ongoing).setPriority(this.priority).setOnlyAlertOnce(this.onlyAlertOnce).setAutoCancel(true);
        if (this.remoteViews != null) {
            notificationBuilder.setContent(this.remoteViews);
        }
        if (this.intent != null) {
            notificationBuilder.setContentIntent(this.intent);
        }
        if (this.ticker != null && this.ticker.length() > 0) {
            notificationBuilder.setTicker((CharSequence)this.ticker);
        }
        if (this.when != 0L) {
            notificationBuilder.setWhen(this.when);
        }
        if (this.sound != null) {
            notificationBuilder.setSound(this.sound);
        }
        if (this.defaults != 0) {
            notificationBuilder.setDefaults(this.defaults);
        }
        if (this.pattern != null) {
            notificationBuilder.setVibrate(this.pattern);
        }
        return notificationBuilder;
    }

    public NotificationUtils setOngoing(boolean ongoing) {
        this.ongoing = ongoing;
        return this;
    }

    public NotificationUtils setContent(RemoteViews remoteViews) {
        this.remoteViews = remoteViews;
        return this;
    }

    public NotificationUtils setContentIntent(PendingIntent intent) {
        this.intent = intent;
        return this;
    }

    public NotificationUtils setTicker(String ticker) {
        this.ticker = ticker;
        return this;
    }

    public NotificationUtils setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public NotificationUtils setOnlyAlertOnce(boolean onlyAlertOnce) {
        this.onlyAlertOnce = onlyAlertOnce;
        return this;
    }

    public NotificationUtils setWhen(long when) {
        this.when = when;
        return this;
    }

    public NotificationUtils setSound(Uri sound) {
        this.sound = sound;
        return this;
    }

    public NotificationUtils setDefaults(int defaults) {
        this.defaults = defaults;
        return this;
    }

    public NotificationUtils setVibrate(long[] pattern) {
        this.pattern = pattern;
        return this;
    }

    public NotificationUtils setFlags(int ... flags) {
        this.flags = flags;
        return this;
    }
}

