/*
 * Decompiled with CFR 0.152.
 */
package cn.ycbjie.ycstatusbarlib.bar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import cn.ycbjie.ycstatusbarlib.R;
import cn.ycbjie.ycstatusbarlib.StatusBarUtils;
import cn.ycbjie.ycstatusbarlib.bar.StateAppBar;
import cn.ycbjie.ycstatusbarlib.view.StatusBarView;
import java.lang.reflect.Field;

@TargetApi(value=19)
final class BarStatusKitKat {
    private static final String TAG_FAKE_STATUS_BAR_VIEW = "statusBarView";
    private static final String TAG_MARGIN_ADDED = "marginAdded";

    BarStatusKitKat() {
    }

    static void setStatusBarColor(Activity activity, int statusColor) {
        int actionBarId;
        View view;
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        BarStatusKitKat.removeFakeStatusBarViewIfExist(activity);
        BarStatusKitKat.addFakeStatusBarView(activity, statusColor, statusBarHeight);
        BarStatusKitKat.addMarginTopToContentChild(mContentChild, statusBarHeight);
        if (mContentChild != null) {
            mContentChild.setFitsSystemWindows(false);
        }
        if ((view = activity.findViewById(actionBarId = activity.getResources().getIdentifier("action_bar", "id", activity.getPackageName()))) != null) {
            TypedValue typedValue = new TypedValue();
            if (activity.getTheme().resolveAttribute(R.attr.actionBarSize, typedValue, true)) {
                int actionBarHeight = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)activity.getResources().getDisplayMetrics());
                StateAppBar.setContentTopPadding(activity, actionBarHeight);
            }
        }
    }

    static void translucentStatusBar(Activity activity) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        BarStatusKitKat.removeFakeStatusBarViewIfExist(activity);
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        BarStatusKitKat.removeMarginTopOfContentChild(mContentChild, statusBarHeight);
        if (mContentChild != null) {
            mContentChild.setFitsSystemWindows(false);
        }
    }

    static void setStatusBarColorForCollapsingToolbar(Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, int statusColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        mContentChild.setFitsSystemWindows(false);
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        BarStatusKitKat.removeFakeStatusBarViewIfExist(activity);
        BarStatusKitKat.removeMarginTopOfContentChild(mContentChild, statusBarHeight);
        final View statusView = BarStatusKitKat.addFakeStatusBarView(activity, statusColor, statusBarHeight);
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior();
        if (behavior != null && behavior instanceof AppBarLayout.Behavior) {
            int verticalOffset = ((AppBarLayout.Behavior)behavior).getTopAndBottomOffset();
            if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                statusView.setAlpha(1.0f);
            } else {
                statusView.setAlpha(0.0f);
            }
        } else {
            statusView.setAlpha(0.0f);
        }
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                    if (statusView.getAlpha() == 0.0f) {
                        statusView.animate().cancel();
                        statusView.animate().alpha(1.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                    }
                } else if (statusView.getAlpha() == 1.0f) {
                    statusView.animate().cancel();
                    statusView.animate().alpha(0.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                }
            }
        });
    }

    static void setStatusBarWhiteForCollapsingToolbar(final Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, int statusBarColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        mContentChild.setFitsSystemWindows(false);
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        int color2 = -16777216;
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            color2 = statusBarColor;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            color2 = statusBarColor;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        final View statusView = BarStatusKitKat.addFakeStatusBarView(activity, color2, statusBarHeight);
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior();
        if (behavior != null && behavior instanceof AppBarLayout.Behavior) {
            int verticalOffset = ((AppBarLayout.Behavior)behavior).getTopAndBottomOffset();
            if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                statusView.setAlpha(1.0f);
            } else {
                statusView.setAlpha(0.0f);
            }
        } else {
            statusView.setAlpha(0.0f);
        }
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){
            private static final int EXPANDED = 0;
            private static final int COLLAPSED = 1;
            private int appBarLayoutState;

            @SuppressLint(value={"NewApi"})
            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) >= appBarLayout.getTotalScrollRange() - StateAppBar.getPxFromDp((Context)activity, 56.0f)) {
                    if (this.appBarLayoutState != 1) {
                        this.appBarLayoutState = 1;
                        if (StateAppBar.setStatusBarLightMode(activity, true) || StateAppBar.FlymeSetStatusBarLightMode(activity, true)) {
                            // empty if block
                        }
                        if (statusView.getAlpha() == 0.0f) {
                            statusView.animate().cancel();
                            statusView.animate().alpha(1.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                        }
                    }
                } else if (this.appBarLayoutState != 0) {
                    this.appBarLayoutState = 0;
                    if (StateAppBar.setStatusBarLightMode(activity, false) || StateAppBar.FlymeSetStatusBarLightMode(activity, false)) {
                        // empty if block
                    }
                    if (statusView.getAlpha() == 1.0f) {
                        statusView.animate().cancel();
                        statusView.animate().alpha(0.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                    }
                    BarStatusKitKat.translucentStatusBar(activity);
                }
            }
        });
    }

    private static void removeFakeStatusBarViewIfExist(Activity activity) {
        Window window = activity.getWindow();
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        View fakeView = mDecorView.findViewWithTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        if (fakeView != null) {
            mDecorView.removeView(fakeView);
        }
    }

    private static View addFakeStatusBarView(Activity activity, int statusBarColor, int statusBarHeight) {
        Window window = activity.getWindow();
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        StatusBarView mStatusBarView = new StatusBarView((Context)activity);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, statusBarHeight);
        layoutParams.gravity = 48;
        mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        mStatusBarView.setBackgroundColor(statusBarColor);
        mStatusBarView.setTag(TAG_FAKE_STATUS_BAR_VIEW);
        mDecorView.addView((View)mStatusBarView);
        return mStatusBarView;
    }

    private static void addMarginTopToContentChild(View mContentChild, int statusBarHeight) {
        if (mContentChild == null) {
            return;
        }
        if (!TAG_MARGIN_ADDED.equals(mContentChild.getTag())) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin += statusBarHeight;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag((Object)TAG_MARGIN_ADDED);
        }
    }

    private static void removeMarginTopOfContentChild(View mContentChild, int statusBarHeight) {
        if (mContentChild == null) {
            return;
        }
        if (TAG_MARGIN_ADDED.equals(mContentChild.getTag())) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin -= statusBarHeight;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag(null);
        }
    }
}

