/*
 * Decompiled with CFR 0.152.
 */
package cn.ycbjie.ycstatusbarlib;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import cn.ycbjie.ycstatusbarlib.bar.StateAppBar;

public class StatusBarUtils {
    private static final String TAG = "StatusBarHeightUtils";

    public static int getStatusBarHeight(Context context) {
        StatusBarUtils.checkNull(context);
        int statusBarHeight = 0;
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public static boolean isStatusBarVisible(Activity activity) {
        if ((activity.getWindow().getAttributes().flags & 0x400) == 0) {
            Log.d((String)TAG, (String)"status bar is visible");
            return true;
        }
        Log.d((String)TAG, (String)"status bar is not visible");
        return false;
    }

    public static int StatusBarLightMode(Activity activity) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            if (StateAppBar.setStatusBarLightMode(activity, true)) {
                result = 1;
            } else if (StateAppBar.FlymeSetStatusBarLightMode(activity, true)) {
                result = 2;
            } else if (Build.VERSION.SDK_INT >= 23) {
                activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                result = 3;
            }
        }
        return result;
    }

    public static void StatusBarLightMode(Activity activity, int type) {
        if (type == 1) {
            StateAppBar.setStatusBarLightMode(activity, true);
        } else if (type == 2) {
            StateAppBar.FlymeSetStatusBarLightMode(activity, true);
        } else if (type == 3 && Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT >= 23) {
            activity.getWindow().getDecorView().setSystemUiVisibility(9216);
        }
    }

    public static void StatusBarDarkMode(Activity activity, int type) {
        if (type == 1) {
            StateAppBar.setStatusBarLightMode(activity, false);
        } else if (type == 2) {
            StateAppBar.FlymeSetStatusBarLightMode(activity, false);
        } else if (type == 3) {
            activity.getWindow().getDecorView().setSystemUiVisibility(0);
        }
    }

    public static void checkNull(Object object) {
        if (object == null) {
            throw new NullPointerException("object is not null");
        }
    }
}

