/*
 * Decompiled with CFR 0.152.
 */
package cn.ycbjie.ycstatusbarlib.bar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import cn.ycbjie.ycstatusbarlib.bar.AppBar;

@TargetApi(value=21)
class BarStatusLollipop {
    BarStatusLollipop() {
    }

    static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(statusColor);
        window.getDecorView().setSystemUiVisibility(0);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        Window window = activity.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        if (hideStatusBarBackground) {
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
            window.getDecorView().setSystemUiVisibility(1280);
        } else {
            window.addFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(0);
        }
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void setStatusBarColorForCollapsingToolbar(final Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, final int statusColor) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        window.getDecorView().setSystemUiVisibility(0);
        ViewCompat.setOnApplyWindowInsetsListener((View)collapsingToolbarLayout, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return insets;
            }
        });
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        collapsingToolbarLayout.setStatusBarScrimColor(statusColor);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = BarStatusLollipop.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){
            private static final int EXPANDED = 0;
            private static final int COLLAPSED = 1;
            private int appBarLayoutState;

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) > collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                    if (this.appBarLayoutState != 1) {
                        this.appBarLayoutState = 1;
                        BarStatusLollipop.setStatusBarColor(activity, statusColor);
                    }
                } else if (this.appBarLayoutState != 0) {
                    this.appBarLayoutState = 0;
                    BarStatusLollipop.translucentStatusBar(activity, true);
                }
            }
        });
    }

    static void setStatusBarWhiteForCollapsingToolbar(final Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, final int statusBarColor) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        window.getDecorView().setSystemUiVisibility(0);
        ViewCompat.setOnApplyWindowInsetsListener((View)collapsingToolbarLayout, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return insets;
            }
        });
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = BarStatusLollipop.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        collapsingToolbarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        collapsingToolbarLayout.setStatusBarScrimColor(statusBarColor);
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){
            private static final int EXPANDED = 0;
            private static final int COLLAPSED = 1;
            private int appBarLayoutState;

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) > collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                    if (this.appBarLayoutState != 1) {
                        this.appBarLayoutState = 1;
                        if (AppBar.setStatusBarLightMode(activity, true)) {
                            return;
                        }
                        if (Build.VERSION.SDK_INT >= 23) {
                            activity.getWindow().setBackgroundDrawableResource(17170445);
                            activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                            activity.getWindow().setStatusBarColor(statusBarColor);
                        } else if (!AppBar.FlymeSetStatusBarLightMode(activity, true)) {
                            BarStatusLollipop.setStatusBarColor(activity, statusBarColor);
                        }
                    }
                } else if (this.appBarLayoutState != 0) {
                    this.appBarLayoutState = 0;
                    if (AppBar.setStatusBarLightMode(activity, false)) {
                        BarStatusLollipop.translucentStatusBar(activity, true);
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 23) {
                        activity.getWindow().getDecorView().setSystemUiVisibility(256);
                    } else if (AppBar.FlymeSetStatusBarLightMode(activity, true)) {
                        // empty if block
                    }
                    BarStatusLollipop.translucentStatusBar(activity, true);
                }
            }
        });
    }

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }
}

