/*
 * Decompiled with CFR 0.152.
 */
package com.ycbjie.ycreddotviewlib;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TabWidget;
import android.widget.TextView;

public class YCRedDotView
extends AppCompatTextView {
    private boolean mHideOnNull = true;

    public YCRedDotView(Context context) {
        this(context, null);
    }

    public YCRedDotView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public YCRedDotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.isHideOnNull() && (text == null || text.toString().equalsIgnoreCase("0"))) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
        super.setText(text, type);
    }

    private void initView() {
        this.setLayoutParams();
        this.setTextView();
        this.setDefaultValues();
    }

    private void setLayoutParams() {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (!(layoutParams instanceof LinearLayout.LayoutParams)) {
            LinearLayout.LayoutParams lParams = new LinearLayout.LayoutParams(-2, -2, 8388661.0f);
            this.setLayoutParams((ViewGroup.LayoutParams)lParams);
        }
    }

    private void setTextView() {
        this.setTextColor(-1);
        this.setTypeface(Typeface.DEFAULT_BOLD);
        this.setTextSize(2, 10.0f);
        this.setPadding(this.dip2Px(5.0f), this.dip2Px(1.0f), this.dip2Px(5.0f), this.dip2Px(1.0f));
        this.setBackground(9, Color.parseColor((String)"#f14850"));
        this.setGravity(17);
    }

    private void setDefaultValues() {
        this.setHideOnNull(true);
        this.setBadgeCount(0);
    }

    public void setBackground(int dipRadius, int badgeColor) {
        int radius = this.dip2Px(dipRadius);
        float[] radiusArray = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
        RoundRectShape roundRect = new RoundRectShape(radiusArray, null, null);
        ShapeDrawable bgDrawable = new ShapeDrawable((Shape)roundRect);
        bgDrawable.getPaint().setColor(badgeColor);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)bgDrawable);
        }
    }

    public void setHideOnNull(boolean hideOnNull) {
        this.mHideOnNull = hideOnNull;
        this.setText(this.getText());
    }

    public boolean isHideOnNull() {
        return this.mHideOnNull;
    }

    public void setBadgeCount(int count) {
        this.setBadgeCount(count > 99 ? "99+" : String.valueOf(count));
    }

    private void setBadgeCount(String count) {
        this.setText(count);
    }

    public void setTargetView(TabWidget target, int tabIndex) {
        View tabView = target.getChildTabViewAt(tabIndex);
        this.setTargetView(tabView);
    }

    public void setTargetView(TabLayout target, int tabIndex) {
        TabLayout.Tab tabAt = target.getTabAt(tabIndex);
        View customView = null;
        if (tabAt != null) {
            customView = tabAt.getCustomView();
        }
        this.setTargetView(customView);
    }

    public void setTargetView(View view) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (view == null) {
            return;
        }
        if (view.getParent() instanceof FrameLayout) {
            ((FrameLayout)view.getParent()).addView((View)this);
        } else if (view.getParent() instanceof ViewGroup) {
            ViewGroup parentContainer = (ViewGroup)view.getParent();
            int groupIndex = parentContainer.indexOfChild(view);
            parentContainer.removeView(view);
            FrameLayout badgeContainer = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams parentLayoutParams = view.getLayoutParams();
            badgeContainer.setLayoutParams(parentLayoutParams);
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            parentContainer.addView((View)badgeContainer, groupIndex, parentLayoutParams);
            badgeContainer.addView(view);
            badgeContainer.addView((View)this);
        } else {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"ParentView is must needed");
        }
    }

    public void setRedHotViewGravity(int gravity) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.gravity = gravity;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setBadgeMargin(int dipMargin) {
        this.setBadgeMargin(dipMargin, dipMargin, dipMargin, dipMargin);
    }

    public void setBadgeMargin(int leftDipMargin, int topDipMargin, int rightDipMargin, int bottomDipMargin) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.leftMargin = this.dip2Px(leftDipMargin);
        params.topMargin = this.dip2Px(topDipMargin);
        params.rightMargin = this.dip2Px(rightDipMargin);
        params.bottomMargin = this.dip2Px(bottomDipMargin);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int dip2Px(float dip) {
        return (int)(dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }
}

