/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.ycprogresslib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.ns.yc.ycprogresslib.ProgressBarUtils;
import com.ns.yc.ycprogresslib.R;

public class CarlProgressbar
extends View {
    private int mMaxProgress = 100;
    private int mCurrentProgress = 0;
    private int mReachedBarColor;
    private int mUnreachedBarColor;
    private float mReachedBarHeight;
    private float mUnreachedBarHeight;
    private int mTotalWidth;
    private Paint mReachedBarPaint;
    private Paint mUnreachedBarPaint;
    private RectF mUnreachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private RectF mReachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean mDrawUnreachedBar = true;
    private boolean mDrawReachedBar = true;
    private View customView;
    int customViewX = 0;
    int customViewY = 0;
    int[] point = new int[2];
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mLayoutParams;

    public CarlProgressbar(Context context) {
        this(context, null);
    }

    public CarlProgressbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CarlProgressbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeAttrs(context, attrs, defStyleAttr);
        this.initializePainters();
    }

    protected void onDraw(Canvas canvas) {
        this.drawCanvas(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specValue;
        int defaultSize = 200;
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        this.mTotalWidth = specValue = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (mode) {
            case 0: {
                this.mTotalWidth = defaultSize;
                break;
            }
            case 0x40000000: {
                this.mTotalWidth = specValue;
                break;
            }
            case -2147483648: {
                this.mTotalWidth = Math.min(defaultSize, specValue);
                break;
            }
        }
        Log.i((String)"\u6d4b\u91cf--onMeasure--", (String)(this.mTotalWidth + "----" + this.mReachedBarHeight));
        this.setMeasuredDimension(this.mTotalWidth, (int)(this.mReachedBarHeight * 1.5f));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.getLocationOnScreen(this.point);
    }

    private void initializeAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CarlProgressbar, defStyleAttr, 0);
        this.mReachedBarColor = attributes.getColor(R.styleable.CarlProgressbar_carl_progress_reached_color, -7829368);
        this.mUnreachedBarColor = attributes.getColor(R.styleable.CarlProgressbar_carl_progress_unreached_color, -12303292);
        this.mReachedBarHeight = attributes.getDimension(R.styleable.CarlProgressbar_carl_progress_reached_bar_height, ProgressBarUtils.dp2px(context, 1.5f));
        this.mUnreachedBarHeight = attributes.getDimension(R.styleable.CarlProgressbar_carl_progress_unreached_bar_height, ProgressBarUtils.dp2px(context, 1.0f));
        this.setProgress(attributes.getInt(R.styleable.CarlProgressbar_carl_progress_current, 0));
        this.setMax(attributes.getInt(R.styleable.CarlProgressbar_carl_progress_max, 100));
        attributes.recycle();
        this.initView(context);
    }

    private void initializePainters() {
        this.mReachedBarPaint = new Paint(1);
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.mUnreachedBarPaint = new Paint(1);
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
    }

    private void initView(Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mLayoutParams.gravity = 0x800033;
        this.mLayoutParams.width = -2;
        this.mLayoutParams.height = -2;
        this.mLayoutParams.format = -3;
        this.mLayoutParams.flags = 524328;
        this.mLayoutParams.type = Build.VERSION.SDK_INT >= 25 ? 2 : 2005;
    }

    private void drawCanvas(Canvas canvas) {
        this.calculateDrawRectFWithoutProgressText();
        if (this.mDrawReachedBar) {
            canvas.drawRect(this.mReachedRectF, this.mReachedBarPaint);
        }
        if (this.mDrawUnreachedBar) {
            canvas.drawRect(this.mUnreachedRectF, this.mUnreachedBarPaint);
        }
        this.calculationToastIndex();
        this.drawCustom();
        this.showCustomView();
    }

    private void calculateDrawRectFWithoutProgressText() {
        this.mReachedRectF.left = this.getPaddingLeft();
        this.mReachedRectF.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
        this.mReachedRectF.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.mMaxProgress * 1.0f) * (float)this.mCurrentProgress + (float)this.getPaddingLeft();
        this.mReachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
        this.mUnreachedRectF.left = this.mReachedRectF.right;
        this.mUnreachedRectF.right = this.getWidth() - this.getPaddingRight();
        this.mUnreachedRectF.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
        this.mUnreachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
    }

    private void calculationToastIndex() {
        int width = View.MeasureSpec.makeMeasureSpec((int)0x3FFFFFFF, (int)Integer.MIN_VALUE);
        int height = View.MeasureSpec.makeMeasureSpec((int)0x3FFFFFFF, (int)Integer.MIN_VALUE);
        if (this.customView != null) {
            this.customView.measure(width, height);
            this.customViewY = (int)((float)(this.point[1] - this.getStatusBarHeight()) - ((float)this.customView.getMeasuredHeight() - this.mReachedBarHeight / 2.0f));
            this.customViewX = this.mTotalWidth * this.mCurrentProgress / this.mMaxProgress + this.point[0] - this.customView.getMeasuredWidth() / 2;
        }
    }

    private void drawCustom() {
        if (this.customView == null) {
            return;
        }
        if (this.customView.getVisibility() == 8) {
            this.customView.setVisibility(0);
        }
        this.mLayoutParams.x = this.customViewX;
        this.mLayoutParams.y = this.customViewY;
        if (this.customView.getParent() == null) {
            this.mWindowManager.addView(this.customView, (ViewGroup.LayoutParams)this.mLayoutParams);
        } else {
            this.mWindowManager.updateViewLayout(this.customView, (ViewGroup.LayoutParams)this.mLayoutParams);
        }
    }

    private void showCustomView() {
        if (this.customView != null && this.customView.getParent() != null) {
            this.customView.setVisibility(0);
        }
    }

    private void hideCustomView(View view) {
        if (view == null) {
            return;
        }
        view.setVisibility(8);
        if (view.getParent() != null) {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void setCustomView(View view) {
        this.customView = view;
    }

    private int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public void setUnreachedBarColor(@ColorInt int barColor) {
        this.mUnreachedBarColor = barColor;
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.invalidate();
    }

    public void setReachedBarColor(@ColorInt int progressColor) {
        this.mReachedBarColor = progressColor;
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.invalidate();
    }

    public void setReachedBarHeight(float height) {
        this.mReachedBarHeight = height;
    }

    public void setUnreachedBarHeight(float height) {
        this.mUnreachedBarHeight = height;
    }

    public void setReachedBarDraw(boolean drawUnreachedBar) {
        this.mDrawUnreachedBar = drawUnreachedBar;
    }

    public void setMax(int maxProgress) {
        if (maxProgress > 0) {
            this.mMaxProgress = maxProgress;
            this.invalidate();
        }
    }

    public void setProgress(int progress) {
        if (progress <= this.mMaxProgress && progress >= 0) {
            this.mCurrentProgress = progress;
            this.requestLayout();
        }
    }
}

