/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.ycprogresslib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.ns.yc.ycprogresslib.R;

public class RingProgressBar
extends View {
    private int progress;
    private int percent;
    private int progressMax;
    private int dotColor;
    private int dotBgColor;
    private int showMode;
    public static final int SHOW_MODE_NULL = 0;
    public static final int SHOW_MODE_PERCENT = 1;
    public static final int SHOW_MODE_ALL = 2;
    private float percentTextSize;
    private int percentTextColor;
    private boolean isPercentFontSystem;
    private int percentThinPadding;
    private String unitText;
    private float unitTextSize;
    private int unitTextColor;
    private int unitTextAlignMode;
    public static final int UNIT_TEXT_ALIGN_MODE_DEFAULT = 0;
    public static final int UNIT_TEXT_ALIGN_MODE_CN = 1;
    public static final int UNIT_TEXT_ALIGN_MODE_EN = 2;
    private String buttonText;
    private float buttonTextSize;
    private int buttonTextColor;
    private int buttonBgColor;
    private int buttonClickColor;
    private int buttonClickBgColor;
    private float buttonTopOffset;
    private Paint mPaint;
    private Path mPath;
    private RectF mRectF;
    private float mSin_1;
    private boolean mIsButtonTouched;
    private Typeface mPercentTypeface;
    private PointF mButtonRect_start;
    private PointF mButtonRect_end;
    private float mButtonRadius;
    private View.OnClickListener mButtonClickListener;
    private float mCenterX;
    private float mCenterY;
    private Canvas mCanvas;
    private Bitmap mBitmap;
    private Xfermode mClearCanvasXfermode;
    private Xfermode mPercentThinXfermode;

    public RingProgressBar(Context context) {
        this(context, null);
    }

    public RingProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RingProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RingProgressBar);
        this.progressMax = ta.getInteger(R.styleable.RingProgressBar_progressMax, 100);
        this.dotColor = ta.getColor(R.styleable.RingProgressBar_dotColor, -1);
        this.dotBgColor = ta.getColor(R.styleable.RingProgressBar_dotBgColor, -7829368);
        this.showMode = ta.getInt(R.styleable.RingProgressBar_showMode, 1);
        if (this.showMode != 0) {
            this.percentTextSize = ta.getDimension(R.styleable.RingProgressBar_percentTextSize, (float)this.dp2px(30));
            this.percentTextColor = ta.getInt(R.styleable.RingProgressBar_percentTextColor, -1);
            this.isPercentFontSystem = ta.getBoolean(R.styleable.RingProgressBar_isPercentFontSystem, false);
            this.percentThinPadding = ta.getInt(R.styleable.RingProgressBar_percentThinPadding, 0);
            this.unitText = ta.getString(R.styleable.RingProgressBar_unitText);
            this.unitTextSize = ta.getDimension(R.styleable.RingProgressBar_unitTextSize, this.percentTextSize);
            this.unitTextColor = ta.getInt(R.styleable.RingProgressBar_unitTextColor, -1);
            this.unitTextAlignMode = ta.getInt(R.styleable.RingProgressBar_unitTextAlignMode, 0);
            if (this.unitText == null) {
                this.unitText = "%";
            }
        }
        if (this.showMode == 2) {
            this.buttonText = ta.getString(R.styleable.RingProgressBar_buttonText);
            this.buttonTextSize = ta.getDimension(R.styleable.RingProgressBar_buttonTextSize, (float)this.dp2px(15));
            this.buttonTextColor = ta.getInt(R.styleable.RingProgressBar_buttonTextColor, -7829368);
            this.buttonBgColor = ta.getInt(R.styleable.RingProgressBar_buttonBgColor, -1);
            this.buttonClickColor = ta.getInt(R.styleable.RingProgressBar_buttonClickColor, this.buttonBgColor);
            this.buttonClickBgColor = ta.getInt(R.styleable.RingProgressBar_buttonClickBgColor, this.buttonTextColor);
            this.buttonTopOffset = ta.getDimension(R.styleable.RingProgressBar_buttonTopOffset, (float)this.dp2px(15));
            if (this.buttonText == null) {
                this.buttonText = context.getString(R.string.progress_btn);
            }
        }
        ta.recycle();
        this.mSin_1 = (float)Math.sin(Math.toRadians(1.0));
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPath = new Path();
        this.mRectF = new RectF();
        this.mButtonRect_start = new PointF();
        this.mButtonRect_end = new PointF();
        this.mPercentTypeface = Typeface.DEFAULT;
        this.mClearCanvasXfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        if (this.percentThinPadding != 0) {
            this.mPercentThinXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircleDot(this.mCanvas);
        if (this.showMode != 0) {
            this.drawPercentUnit(this.mCanvas);
            if (this.showMode == 2) {
                this.drawButton(this.mCanvas);
            }
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
    }

    private void drawCircleDot(Canvas canvas) {
        this.mPaint.setXfermode(this.mClearCanvasXfermode);
        this.mCanvas.drawPaint(this.mPaint);
        this.mPaint.setXfermode(null);
        float outerRadius = (float)(this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight()) / 2.0f;
        this.mCenterX = (float)this.getWidth() / 2.0f;
        this.mCenterY = (float)this.getHeight() / 2.0f;
        float dotRadius = this.mSin_1 * outerRadius / (1.0f + this.mSin_1);
        this.mPaint.setColor(this.dotColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        int count = 0;
        while (count++ < this.percent) {
            this.mCanvas.drawCircle(this.mCenterX, this.mCenterY - outerRadius + dotRadius, dotRadius, this.mPaint);
            this.mCanvas.rotate(3.6f, this.mCenterX, this.mCenterY);
        }
        this.mPaint.setColor(this.dotBgColor);
        while (true) {
            int n = --count;
            ++count;
            if (n >= 100) break;
            this.mCanvas.drawCircle(this.mCenterX, this.mCenterY - outerRadius + dotRadius, dotRadius, this.mPaint);
            this.mCanvas.rotate(3.6f, this.mCenterX, this.mCenterY);
        }
    }

    private void drawPercentUnit(Canvas canvas) {
        this.mPaint.setTypeface(this.mPercentTypeface);
        this.mPaint.setTextSize(this.percentTextSize);
        float percentTextWidth = this.mPaint.measureText(this.percent + "");
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize(this.unitTextSize);
        float unitTextWidth = this.mPaint.measureText(this.unitText);
        Paint.FontMetrics fm_unit = this.mPaint.getFontMetrics();
        float textWidth = percentTextWidth + unitTextWidth;
        float baseline = 0.0f;
        if (this.showMode == 1) {
            float textHeight = this.percentTextSize > this.unitTextSize ? this.percentTextSize : this.unitTextSize;
            this.mPaint.setTextSize(textHeight);
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            baseline = this.mCenterY + (fm.descent - fm.ascent) / 2.0f - fm.descent;
        } else if (this.showMode == 2) {
            baseline = this.mCenterY;
        }
        this.mPaint.setTypeface(this.mPercentTypeface);
        this.mPaint.setTextSize(this.percentTextSize);
        this.mPaint.setColor(this.percentTextColor);
        canvas.drawText(this.percent + "", this.mCenterX - textWidth / 2.0f, baseline, this.mPaint);
        if (this.percentThinPadding != 0) {
            this.mPaint.setXfermode(this.mPercentThinXfermode);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.percentThinPadding);
            canvas.drawText(this.percent + "", this.mCenterX - textWidth / 2.0f, baseline, this.mPaint);
            this.mPaint.setXfermode(null);
            this.mPaint.setStyle(Paint.Style.FILL);
        }
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize(this.unitTextSize);
        this.mPaint.setColor(this.unitTextColor);
        switch (this.unitTextAlignMode) {
            case 1: {
                baseline -= fm_unit.descent / 4.0f;
                break;
            }
            case 2: {
                baseline -= fm_unit.descent * 2.0f / 3.0f;
                break;
            }
        }
        canvas.drawText(this.unitText, this.mCenterX - textWidth / 2.0f + percentTextWidth, baseline, this.mPaint);
    }

    private void drawButton(Canvas canvas) {
        this.mPaint.setTextSize(this.buttonTextSize);
        float buttonTextWidth = this.mPaint.measureText(this.buttonText);
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mIsButtonTouched ? this.buttonClickBgColor : this.buttonBgColor);
        float buttonHeight = 2.0f * this.buttonTextSize;
        this.mButtonRadius = buttonHeight / 2.0f;
        this.mButtonRect_start.set(this.mCenterX - buttonTextWidth / 2.0f, this.mCenterY + this.buttonTopOffset);
        this.mButtonRect_end.set(this.mCenterX + buttonTextWidth / 2.0f, this.mCenterY + this.buttonTopOffset + buttonHeight);
        this.mPath.reset();
        this.mPath.moveTo(this.mButtonRect_start.x, this.mButtonRect_start.y);
        this.mPath.rLineTo(buttonTextWidth, 0.0f);
        float left = this.mCenterX + buttonTextWidth / 2.0f - this.mButtonRadius;
        float top = this.mCenterY + this.buttonTopOffset;
        float right = left + 2.0f * this.mButtonRadius;
        float bottom = top + 2.0f * this.mButtonRadius;
        this.mRectF.set(left, top, right, bottom);
        this.mPath.arcTo(this.mRectF, 270.0f, 180.0f);
        this.mPath.rLineTo(-buttonTextWidth, 0.0f);
        this.mRectF.offset(-buttonTextWidth, 0.0f);
        this.mPath.arcTo(this.mRectF, 90.0f, 180.0f);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPaint.setColor(this.mIsButtonTouched ? this.buttonClickColor : this.buttonTextColor);
        float baseline = this.mCenterY + this.buttonTopOffset + this.buttonTextSize + (fm.descent - fm.ascent) / 2.0f - fm.descent;
        canvas.drawText(this.buttonText, this.mCenterX - buttonTextWidth / 2.0f, baseline, this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.showMode == 2) {
            switch (event.getAction()) {
                case 0: {
                    if (!this.isTouchInButton(event.getX(), event.getY())) break;
                    this.mIsButtonTouched = true;
                    this.postInvalidate();
                    break;
                }
                case 2: {
                    if (!this.mIsButtonTouched || this.isTouchInButton(event.getX(), event.getY())) break;
                    this.mIsButtonTouched = false;
                    this.postInvalidate();
                    break;
                }
                case 1: {
                    if (this.mIsButtonTouched && this.mButtonClickListener != null) {
                        this.mButtonClickListener.onClick((View)this);
                    }
                    this.mIsButtonTouched = false;
                    this.postInvalidate();
                    break;
                }
            }
            if (this.mIsButtonTouched) {
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isTouchInButton(float x, float y) {
        if (x >= this.mButtonRect_start.x && x <= this.mButtonRect_end.x && y >= this.mButtonRect_start.y && y <= this.mButtonRect_end.y) {
            return true;
        }
        float centerX = this.mButtonRect_start.x;
        float newX = x - centerX;
        float centerY = (this.mButtonRect_start.y + this.mButtonRect_end.y) / 2.0f;
        float newY = y - centerY;
        if (newX * newX + newY * newY <= this.mButtonRadius * this.mButtonRadius) {
            return true;
        }
        centerX = this.mButtonRect_end.x;
        newX = x - centerX;
        return newX * newX + newY * newY <= this.mButtonRadius * this.mButtonRadius;
    }

    public void setOnButtonClickListener(View.OnClickListener onClickListener) {
        this.mButtonClickListener = onClickListener;
    }

    private int dp2px(int dp) {
        float density = this.getContext().getResources().getDisplayMetrics().density;
        return (int)((float)dp * density + 0.5f);
    }

    public synchronized int getProgressMax() {
        return this.progressMax;
    }

    public synchronized void setProgressMax(int progressMax) {
        if (progressMax < 0) {
            throw new IllegalArgumentException("progressMax mustn't smaller than 0");
        }
        this.progressMax = progressMax;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0 || progress > this.progressMax) {
            throw new IllegalArgumentException(String.format(this.getResources().getString(R.string.progress_out_of_range), this.progressMax));
        }
        this.progress = progress;
        this.percent = progress * 100 / this.progressMax;
        this.postInvalidate();
    }

    public int getPercent() {
        return this.percent;
    }

    public int getDotColor() {
        return this.dotColor;
    }

    public void setDotColor(int dotColor) {
        this.dotColor = dotColor;
    }

    public int getDotBgColor() {
        return this.dotBgColor;
    }

    public void setDotBgColor(int dotBgColor) {
        this.dotBgColor = dotBgColor;
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setShowMode(int showMode) {
        this.showMode = showMode;
    }

    public float getPercentTextSize() {
        return this.percentTextSize;
    }

    public void setPercentTextSize(float percentTextSize) {
        this.percentTextSize = percentTextSize;
    }

    public int getPercentTextColor() {
        return this.percentTextColor;
    }

    public void setPercentTextColor(int percentTextColor) {
        this.percentTextColor = percentTextColor;
    }

    public boolean isPercentFontSystem() {
        return this.isPercentFontSystem;
    }

    public void setIsPercentFontSystem(boolean isPercentFontSystem) {
        this.isPercentFontSystem = isPercentFontSystem;
    }

    public int getPercentThinPadding() {
        return this.percentThinPadding;
    }

    public void setPercentThinPadding(int percentThinPadding) {
        this.percentThinPadding = percentThinPadding;
    }

    public String getUnitText() {
        return this.unitText;
    }

    public void setUnitText(String unitText) {
        this.unitText = unitText;
    }

    public float getUnitTextSize() {
        return this.unitTextSize;
    }

    public void setUnitTextSize(float unitTextSize) {
        this.unitTextSize = unitTextSize;
    }

    public int getUnitTextColor() {
        return this.unitTextColor;
    }

    public void setUnitTextColor(int unitTextColor) {
        this.unitTextColor = unitTextColor;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public float getButtonTextSize() {
        return this.buttonTextSize;
    }

    public void setButtonTextSize(float buttonTextSize) {
        this.buttonTextSize = buttonTextSize;
    }

    public int getButtonTextColor() {
        return this.buttonTextColor;
    }

    public void setButtonTextColor(int buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    public int getButtonBgColor() {
        return this.buttonBgColor;
    }

    public void setButtonBgColor(int buttonBgColor) {
        this.buttonBgColor = buttonBgColor;
    }

    public int getButtonClickColor() {
        return this.buttonClickColor;
    }

    public void setButtonClickColor(int buttonClickColor) {
        this.buttonClickColor = buttonClickColor;
    }

    public int getButtonClickBgColor() {
        return this.buttonClickBgColor;
    }

    public void setButtonClickBgColor(int buttonClickBgColor) {
        this.buttonClickBgColor = buttonClickBgColor;
    }

    public int getUnitTextAlignMode() {
        return this.unitTextAlignMode;
    }

    public void setUnitTextAlignMode(int unitTextAlignMode) {
        this.unitTextAlignMode = unitTextAlignMode;
    }

    public float getButtonTopOffset() {
        return this.buttonTopOffset;
    }

    public void setButtonTopOffset(float buttonTopOffset) {
        this.buttonTopOffset = buttonTopOffset;
    }
}

