/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.ycprogresslib;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.ns.yc.ycprogresslib.R;

public class CircleProgressbar
extends AppCompatTextView {
    private int outLineColor = -16777216;
    private int outLineWidth = 2;
    private ColorStateList inCircleColors = ColorStateList.valueOf((int)0);
    private int circleColor;
    private int progressLineColor = -16776961;
    private int progressLineWidth = 8;
    private Paint mPaint = new Paint();
    private RectF mArcRect = new RectF();
    private int progress = 100;
    private ProgressType mProgressType = ProgressType.COUNT_BACK;
    private long timeMillis = 3000L;
    final Rect bounds = new Rect();
    private OnCountdownProgressListener mCountdownProgressListener;
    private int listenerWhat = 0;
    private Runnable progressChangeTask = new Runnable(){

        @Override
        public void run() {
            CircleProgressbar.this.removeCallbacks(this);
            switch (CircleProgressbar.this.mProgressType) {
                case COUNT: {
                    CircleProgressbar.this.progress = CircleProgressbar.this.progress + 1;
                    break;
                }
                case COUNT_BACK: {
                    CircleProgressbar.this.progress = CircleProgressbar.this.progress - 1;
                    break;
                }
            }
            if (CircleProgressbar.this.progress >= 0 && CircleProgressbar.this.progress <= 100) {
                if (CircleProgressbar.this.mCountdownProgressListener != null) {
                    CircleProgressbar.this.mCountdownProgressListener.onProgress(CircleProgressbar.this.listenerWhat, CircleProgressbar.this.progress);
                }
                CircleProgressbar.this.invalidate();
                CircleProgressbar.this.postDelayed(CircleProgressbar.this.progressChangeTask, CircleProgressbar.this.timeMillis / 100L);
            } else {
                CircleProgressbar.this.progress = CircleProgressbar.this.validateProgress(CircleProgressbar.this.progress);
            }
        }
    };

    public CircleProgressbar(Context context) {
        this(context, null);
    }

    public CircleProgressbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attributeSet) {
        this.mPaint.setAntiAlias(true);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CircleProgressbar);
        this.inCircleColors = typedArray.hasValue(R.styleable.CircleProgressbar_circle_color) ? typedArray.getColorStateList(R.styleable.CircleProgressbar_circle_color) : ColorStateList.valueOf((int)0);
        this.circleColor = this.inCircleColors.getColorForState(this.getDrawableState(), 0);
        typedArray.recycle();
    }

    protected void onDraw(Canvas canvas) {
        this.getDrawingRect(this.bounds);
        int size = this.bounds.height() > this.bounds.width() ? this.bounds.width() : this.bounds.height();
        float outerRadius = size / 2;
        int circleColor = this.inCircleColors.getColorForState(this.getDrawableState(), 0);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(circleColor);
        canvas.drawCircle((float)this.bounds.centerX(), (float)this.bounds.centerY(), outerRadius - (float)this.outLineWidth, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.outLineWidth);
        this.mPaint.setColor(this.outLineColor);
        canvas.drawCircle((float)this.bounds.centerX(), (float)this.bounds.centerY(), outerRadius - (float)(this.outLineWidth / 2), this.mPaint);
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        float textY = (float)this.bounds.centerY() - (paint.descent() + paint.ascent()) / 2.0f;
        canvas.drawText(this.getText().toString(), (float)this.bounds.centerX(), textY, (Paint)paint);
        this.mPaint.setColor(this.progressLineColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.progressLineWidth);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        int deleteWidth = this.progressLineWidth + this.outLineWidth;
        this.mArcRect.set((float)(this.bounds.left + deleteWidth / 2), (float)(this.bounds.top + deleteWidth / 2), (float)(this.bounds.right - deleteWidth / 2), (float)(this.bounds.bottom - deleteWidth / 2));
        canvas.drawArc(this.mArcRect, 0.0f, (float)(360 * this.progress / 100), false, this.mPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int lineWidth = 4 * (this.outLineWidth + this.progressLineWidth);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int size = (width > height ? width : height) + lineWidth;
        this.setMeasuredDimension(size, size);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.validateCircleColor();
    }

    public void setOutLineColor(@ColorInt int outLineColor) {
        this.outLineColor = outLineColor;
        this.invalidate();
    }

    public void setOutLineWidth(int outLineWidth) {
        this.outLineWidth = outLineWidth;
        this.invalidate();
    }

    public void setInCircleColor(@ColorInt int inCircleColor) {
        this.inCircleColors = ColorStateList.valueOf((int)inCircleColor);
        this.invalidate();
    }

    private void validateCircleColor() {
        int circleColorTemp = this.inCircleColors.getColorForState(this.getDrawableState(), 0);
        if (this.circleColor != circleColorTemp) {
            this.circleColor = circleColorTemp;
            this.invalidate();
        }
    }

    public void setProgressColor(@ColorInt int progressLineColor) {
        this.progressLineColor = progressLineColor;
        this.invalidate();
    }

    public void setProgressLineWidth(int progressLineWidth) {
        this.progressLineWidth = progressLineWidth;
        this.invalidate();
    }

    public void setProgress(int progress) {
        this.progress = this.validateProgress(progress);
        this.invalidate();
    }

    private int validateProgress(int progress) {
        if (progress > 100) {
            progress = 100;
        } else if (progress < 0) {
            progress = 0;
        }
        return progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
        this.invalidate();
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public void setProgressType(ProgressType progressType) {
        this.mProgressType = progressType;
        this.resetProgress();
        this.invalidate();
    }

    private void resetProgress() {
        switch (this.mProgressType) {
            case COUNT: {
                this.progress = 0;
                break;
            }
            case COUNT_BACK: {
                this.progress = 100;
                break;
            }
        }
    }

    public ProgressType getProgressType() {
        return this.mProgressType;
    }

    public void setCountdownProgressListener(int what, OnCountdownProgressListener mCountdownProgressListener) {
        this.listenerWhat = what;
        this.mCountdownProgressListener = mCountdownProgressListener;
    }

    public void start() {
        this.stop();
        this.post(this.progressChangeTask);
    }

    public void reStart() {
        this.resetProgress();
        this.start();
    }

    public void stop() {
        if (this.progressChangeTask != null) {
            this.removeCallbacks(this.progressChangeTask);
        }
    }

    public static interface OnCountdownProgressListener {
        public void onProgress(int var1, int var2);
    }

    public static enum ProgressType {
        COUNT,
        COUNT_BACK;

    }
}

