/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.pwdEt;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.ns.yc.yccustomtextlib.R;

public class PasswordEditText
extends AppCompatEditText {
    private static final String TAG = "PasswordEditText";
    @DrawableRes
    private int mShowPwdIcon = R.drawable.ic_visibility_24dp;
    @DrawableRes
    private int mHidePwdIcon = R.drawable.ic_visibility_off_24dp;
    private boolean mIsShowPwdIcon;
    private Drawable mDrawableSide;

    public PasswordEditText(Context context) {
        this(context, null);
    }

    public PasswordEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFields(attrs, 0);
    }

    @TargetApi(value=21)
    public PasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFields(attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFields(AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray styles = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.PasswordEditText, defStyleAttr, 0);
            try {
                this.mShowPwdIcon = styles.getResourceId(R.styleable.PasswordEditText_pet_iconShow, this.mShowPwdIcon);
                this.mHidePwdIcon = styles.getResourceId(R.styleable.PasswordEditText_pet_iconHide, this.mHidePwdIcon);
            }
            finally {
                styles.recycle();
            }
        }
        this.setInputType(129);
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s.length() > 0) {
                    PasswordEditText.this.showPasswordVisibilityIndicator(true);
                } else {
                    PasswordEditText.this.restorePasswordIconVisibility(false);
                    PasswordEditText.this.showPasswordVisibilityIndicator(false);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    public Parcelable onSaveInstanceState() {
        Parcelable state = super.onSaveInstanceState();
        return new PwdSavedState(state, this.mIsShowPwdIcon);
    }

    public void onRestoreInstanceState(Parcelable state) {
        PwdSavedState savedState = (PwdSavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIsShowPwdIcon = savedState.isShowingIcon();
        this.restorePasswordIconVisibility(this.mIsShowPwdIcon);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDrawableSide == null) {
            return super.onTouchEvent(event);
        }
        Rect bounds = this.mDrawableSide.getBounds();
        int x = (int)event.getRawX();
        int iconX = (int)this.getTopRightCorner().x;
        int leftIcon = iconX - bounds.width();
        Log.e((String)TAG, (String)("x: " + x + ", leftIcon: " + leftIcon));
        if (x >= leftIcon) {
            this.togglePasswordIconVisibility();
            event.setAction(3);
            return false;
        }
        return super.onTouchEvent(event);
    }

    public PointF getTopRightCorner() {
        float[] src = new float[8];
        float[] dst = new float[]{0.0f, 0.0f, this.getWidth(), 0.0f, 0.0f, this.getHeight(), this.getWidth(), this.getHeight()};
        this.getMatrix().mapPoints(src, dst);
        return new PointF(this.getX() + src[2], this.getY() + src[3]);
    }

    private void showPasswordVisibilityIndicator(boolean shouldShowIcon) {
        if (shouldShowIcon) {
            Drawable drawable2 = this.mIsShowPwdIcon ? ContextCompat.getDrawable((Context)this.getContext(), (int)this.mHidePwdIcon) : ContextCompat.getDrawable((Context)this.getContext(), (int)this.mShowPwdIcon);
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
            this.mDrawableSide = drawable2;
        } else {
            this.setCompoundDrawables(null, null, null, null);
            this.mDrawableSide = null;
        }
    }

    private void togglePasswordIconVisibility() {
        this.mIsShowPwdIcon = !this.mIsShowPwdIcon;
        this.restorePasswordIconVisibility(this.mIsShowPwdIcon);
        this.showPasswordVisibilityIndicator(true);
    }

    private void restorePasswordIconVisibility(boolean isShowPwd) {
        if (isShowPwd) {
            this.setInputType(145);
        } else {
            this.setInputType(129);
        }
        this.setSelection(this.getText().length());
    }

    protected static class PwdSavedState
    extends View.BaseSavedState {
        private final boolean mShowingIcon;
        public static final Parcelable.Creator<PwdSavedState> CREATOR = new Parcelable.Creator<PwdSavedState>(){

            public PwdSavedState createFromParcel(Parcel in) {
                return new PwdSavedState(in);
            }

            public PwdSavedState[] newArray(int size) {
                return new PwdSavedState[size];
            }
        };

        private PwdSavedState(Parcelable superState, boolean showingIcon) {
            super(superState);
            this.mShowingIcon = showingIcon;
        }

        private PwdSavedState(Parcel in) {
            super(in);
            this.mShowingIcon = in.readByte() != 0;
        }

        boolean isShowingIcon() {
            return this.mShowingIcon;
        }

        public void writeToParcel(Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeByte((byte)(this.mShowingIcon ? 1 : 0));
        }
    }
}

