/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.web;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.ns.yc.yccustomtextlib.utils.HyperLibUtils;
import com.ns.yc.yccustomtextlib.web.AfterInitialLoadListener;
import com.ns.yc.yccustomtextlib.web.OnDecorationListener;
import com.ns.yc.yccustomtextlib.web.OnTextChangeListener;
import com.ns.yc.yccustomtextlib.web.WebRichType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;

public class WebViewRichEditor
extends WebView {
    private static final String SETUP_HTML = "file:///android_asset/editor.html";
    private static final String CALLBACK_SCHEME = "re-callback://";
    private static final String STATE_SCHEME = "re-state://";
    private boolean isReady = false;
    private String mContents;
    private OnTextChangeListener mTextChangeListener;
    private OnDecorationListener mDecorationStateListener;
    private AfterInitialLoadListener mLoadListener;

    public WebViewRichEditor(Context context) {
        this(context, null);
    }

    public WebViewRichEditor(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public WebViewRichEditor(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.setWebChromeClient(new WebChromeClient());
        this.setWebViewClient(new EditorWebViewClient());
        this.loadUrl(SETUP_HTML);
        this.applyAttributes(context, attrs);
    }

    public void setOnTextChangeListener(OnTextChangeListener listener) {
        this.mTextChangeListener = listener;
    }

    public void setOnDecorationChangeListener(OnDecorationListener listener) {
        this.mDecorationStateListener = listener;
    }

    public void setOnInitialLoadListener(AfterInitialLoadListener listener) {
        this.mLoadListener = listener;
    }

    private void callback(String text) {
        this.mContents = text.replaceFirst(CALLBACK_SCHEME, "");
        if (this.mTextChangeListener != null) {
            this.mTextChangeListener.onTextChange(this.mContents);
        }
    }

    private void stateCheck(String text) {
        String state = text.replaceFirst(STATE_SCHEME, "").toUpperCase(Locale.ENGLISH);
        ArrayList<WebRichType> types = new ArrayList<WebRichType>();
        for (WebRichType type : WebRichType.values()) {
            if (TextUtils.indexOf((CharSequence)state, (CharSequence)type.name()) == -1) continue;
            types.add(type);
        }
        if (this.mDecorationStateListener != null) {
            this.mDecorationStateListener.onStateChangeListener(state, types);
        }
    }

    private void applyAttributes(Context context, AttributeSet attrs) {
        int[] attrsArray = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrsArray);
        int gravity = ta.getInt(0, -1);
        switch (gravity) {
            case 3: 
            case 0x800003: {
                this.exec("javascript:RE.setTextAlign(\"left\")");
                break;
            }
            case 5: 
            case 0x800005: {
                this.exec("javascript:RE.setTextAlign(\"right\")");
                break;
            }
            case 48: {
                this.exec("javascript:RE.setVerticalAlign(\"top\")");
                break;
            }
            case 80: {
                this.exec("javascript:RE.setVerticalAlign(\"bottom\")");
                break;
            }
            case 16: {
                this.exec("javascript:RE.setVerticalAlign(\"middle\")");
                break;
            }
            case 1: {
                this.exec("javascript:RE.setTextAlign(\"center\")");
                break;
            }
            case 17: {
                this.exec("javascript:RE.setVerticalAlign(\"middle\")");
                this.exec("javascript:RE.setTextAlign(\"center\")");
                break;
            }
        }
        ta.recycle();
    }

    public void setHtml(String contents) {
        if (contents == null) {
            contents = "";
        }
        try {
            this.exec("javascript:RE.setHtml('" + URLEncoder.encode(contents, "UTF-8") + "');");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.mContents = contents;
    }

    public String getHtml() {
        return this.mContents;
    }

    public void setEditorFontColor(int color) {
        String hex = this.convertHexColorString(color);
        this.exec("javascript:RE.setBaseTextColor('" + hex + "');");
    }

    public void setEditorFontSize(int px) {
        this.exec("javascript:RE.setBaseFontSize('" + px + "px');");
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.exec("javascript:RE.setPadding('" + left + "px', '" + top + "px', '" + right + "px', '" + bottom + "px');");
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        this.setPadding(start, top, end, bottom);
    }

    public void setEditorBackgroundColor(int color) {
        this.setBackgroundColor(color);
    }

    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
    }

    public void setBackgroundResource(int resid) {
        Bitmap bitmap = HyperLibUtils.decodeResource(this.getContext(), resid);
        String base64 = HyperLibUtils.toBase64(bitmap);
        bitmap.recycle();
        this.exec("javascript:RE.setBackgroundImage('url(data:image/png;base64," + base64 + ")');");
    }

    public void setBackground(Drawable background) {
        Bitmap bitmap = HyperLibUtils.toBitmap(background);
        String base64 = HyperLibUtils.toBase64(bitmap);
        bitmap.recycle();
        this.exec("javascript:RE.setBackgroundImage('url(data:image/png;base64," + base64 + ")');");
    }

    public void setBackground(String url) {
        this.exec("javascript:RE.setBackgroundImage('url(" + url + ")');");
    }

    public void setEditorWidth(int px) {
        this.exec("javascript:RE.setWidth('" + px + "px');");
    }

    public void setEditorHeight(int px) {
        this.exec("javascript:RE.setHeight('" + px + "px');");
    }

    public void setPlaceholder(String placeholder) {
        this.exec("javascript:RE.setPlaceholder('" + placeholder + "');");
    }

    public void setInputEnabled(Boolean inputEnabled) {
        this.exec("javascript:RE.setInputEnabled(" + inputEnabled + ")");
    }

    public void loadCSS(String cssFile) {
        String jsCSSImport = "(function() {    var head  = document.getElementsByTagName(\"head\")[0];    var link  = document.createElement(\"link\");    link.rel  = \"stylesheet\";    link.type = \"text/css\";    link.href = \"" + cssFile + "\";    link.media = \"all\";    head.appendChild(link);}) ();";
        this.exec("javascript:" + jsCSSImport + "");
    }

    public void undo() {
        this.exec("javascript:RE.undo();");
    }

    public void redo() {
        this.exec("javascript:RE.redo();");
    }

    public void setBold() {
        this.exec("javascript:RE.setBold();");
    }

    public void setItalic() {
        this.exec("javascript:RE.setItalic();");
    }

    public void setSubscript() {
        this.exec("javascript:RE.setSubscript();");
    }

    public void setSuperscript() {
        this.exec("javascript:RE.setSuperscript();");
    }

    public void setStrikeThrough() {
        this.exec("javascript:RE.setStrikeThrough();");
    }

    public void setUnderline() {
        this.exec("javascript:RE.setUnderline();");
    }

    public void setTextColor(int color) {
        this.exec("javascript:RE.prepareInsert();");
        String hex = this.convertHexColorString(color);
        this.exec("javascript:RE.setTextColor('" + hex + "');");
    }

    public void setTextBackgroundColor(int color) {
        this.exec("javascript:RE.prepareInsert();");
        String hex = this.convertHexColorString(color);
        this.exec("javascript:RE.setTextBackgroundColor('" + hex + "');");
    }

    public void setFontSize(int fontSize) {
        if (fontSize > 7 || fontSize < 1) {
            Log.e((String)"RichEditor", (String)"Font size should have a value between 1-7");
        }
        this.exec("javascript:RE.setFontSize('" + fontSize + "');");
    }

    public void removeFormat() {
        this.exec("javascript:RE.removeFormat();");
    }

    public void setHeading(int heading) {
        this.exec("javascript:RE.setHeading('" + heading + "');");
    }

    public void setIndent() {
        this.exec("javascript:RE.setIndent();");
    }

    public void setOutdent() {
        this.exec("javascript:RE.setOutdent();");
    }

    public void setAlignLeft() {
        this.exec("javascript:RE.setJustifyLeft();");
    }

    public void setAlignCenter() {
        this.exec("javascript:RE.setJustifyCenter();");
    }

    public void setAlignRight() {
        this.exec("javascript:RE.setJustifyRight();");
    }

    public void setBlockquote() {
        this.exec("javascript:RE.setBlockquote();");
    }

    public void setBullets() {
        this.exec("javascript:RE.setBullets();");
    }

    public void setNumbers() {
        this.exec("javascript:RE.setNumbers();");
    }

    public void insertImage(String url, String alt) {
        this.exec("javascript:RE.prepareInsert();");
        this.exec("javascript:RE.insertImage('" + url + "', '" + alt + "');");
    }

    public void insertLink(String href, String title) {
        this.exec("javascript:RE.prepareInsert();");
        this.exec("javascript:RE.insertLink('" + href + "', '" + title + "');");
    }

    public void insertTodo() {
        this.exec("javascript:RE.prepareInsert();");
        this.exec("javascript:RE.setTodo('" + HyperLibUtils.getCurrentTime() + "');");
    }

    public void focusEditor() {
        this.requestFocus();
        this.exec("javascript:RE.focus();");
    }

    public void clearFocusEditor() {
        this.exec("javascript:RE.blurFocus();");
    }

    private String convertHexColorString(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }

    protected void exec(final String trigger) {
        if (this.isReady) {
            this.load(trigger);
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WebViewRichEditor.this.exec(trigger);
                }
            }, 100L);
        }
    }

    private void load(String trigger) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.evaluateJavascript(trigger, null);
        } else {
            this.loadUrl(trigger);
        }
    }

    protected class EditorWebViewClient
    extends WebViewClient {
        protected EditorWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            WebViewRichEditor.this.isReady = url.equalsIgnoreCase(WebViewRichEditor.SETUP_HTML);
            if (WebViewRichEditor.this.mLoadListener != null) {
                WebViewRichEditor.this.mLoadListener.onAfterInitialLoad(WebViewRichEditor.this.isReady);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            String decode;
            try {
                decode = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
            if (TextUtils.indexOf((CharSequence)url, (CharSequence)WebViewRichEditor.CALLBACK_SCHEME) == 0) {
                WebViewRichEditor.this.callback(decode);
                return true;
            }
            if (TextUtils.indexOf((CharSequence)url, (CharSequence)WebViewRichEditor.STATE_SCHEME) == 0) {
                WebViewRichEditor.this.stateCheck(decode);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }
}

