/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.ns.yc.yccustomtextlib.utils.HyperLogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HyperLibUtils {
    private static final String IMG_REGEX1 = "<img.*?src=\\\"(.*?)\\\".*?>";
    private static final String IMG_REGEX2 = "<(img|IMG)(.*?)(/>|></img>|>)";
    private static final String IMG_REGEX3 = "(src|SRC)=(\"|')(.*?)(\"|')";
    private static int sDecorViewDelta = 0;

    public static int dip2px(Context context, float dipValue) {
        float m = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * m + 0.5f);
    }

    public static SpannableStringBuilder highlight(String text, String target, int color) {
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        try {
            Pattern p = Pattern.compile(target);
            Matcher m = p.matcher(text);
            while (m.find()) {
                ForegroundColorSpan span = new ForegroundColorSpan(color);
                spannable.setSpan((Object)span, m.start(), m.end(), 33);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spannable;
    }

    public static List<String> cutStringByImgTag(String targetStr) {
        ArrayList<String> splitTextList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(IMG_REGEX1);
        Matcher matcher = pattern.matcher(targetStr);
        int lastIndex = 0;
        while (matcher.find()) {
            if (matcher.start() > lastIndex) {
                splitTextList.add(targetStr.substring(lastIndex, matcher.start()));
            }
            splitTextList.add(targetStr.substring(matcher.start(), matcher.end()));
            lastIndex = matcher.end();
        }
        if (lastIndex != targetStr.length()) {
            splitTextList.add(targetStr.substring(lastIndex));
        }
        return splitTextList;
    }

    public static String getImgSrc(String content) {
        String strSrc = null;
        Pattern pImg = Pattern.compile(IMG_REGEX2);
        Matcher mImg = pImg.matcher(content);
        boolean resultImg = mImg.find();
        if (resultImg) {
            while (resultImg) {
                String strImg = mImg.group(2);
                Pattern pSrc = Pattern.compile(IMG_REGEX3);
                Matcher mSrc = pSrc.matcher(strImg);
                if (mSrc.find()) {
                    strSrc = mSrc.group(3);
                }
                resultImg = mImg.find();
            }
        }
        return strSrc;
    }

    public static ArrayList<String> getTextFromHtml(String html, boolean isGetImage) {
        ArrayList<String> imageList = new ArrayList<String>();
        ArrayList<String> textList = new ArrayList<String>();
        List<String> list = HyperLibUtils.cutStringByImgTag(html);
        for (int i = 0; i < list.size(); ++i) {
            String text = list.get(i);
            if (text.contains("<img") && text.contains("src=")) {
                String imagePath = HyperLibUtils.getImgSrc(text);
                imageList.add(imagePath);
                continue;
            }
            textList.add(text);
        }
        if (isGetImage) {
            return imageList;
        }
        return textList;
    }

    public static Bitmap getSmallBitmap(String filePath, int newWidth, int newHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap decodeFile = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        HyperLogUtils.d("HyperLibUtils----getSmallBitmap---byteCount\u538b\u7f29\u524d\u5927\u5c0f--" + decodeFile);
        options.inSampleSize = HyperLibUtils.calculateInSampleSize(options, newWidth, newHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int bitmapByteCount = bitmap.getByteCount();
        HyperLogUtils.d("HyperLibUtils----getSmallBitmap---byteCount\u538b\u7f29\u4e2d\u5927\u5c0f--" + bitmapByteCount);
        Bitmap newBitmap = HyperLibUtils.compressImage(bitmap, 500);
        int byteCount = newBitmap.getByteCount();
        HyperLogUtils.d("HyperLibUtils----getSmallBitmap---byteCount\u538b\u7f29\u540e\u5927\u5c0f--" + byteCount);
        if (bitmap != null) {
            bitmap.recycle();
        }
        return newBitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public static Bitmap compressImage(Bitmap image, int maxSize) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int options = 80;
        image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)os);
        while (os.toByteArray().length / 1024 > maxSize) {
            os.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)os);
        }
        Bitmap bitmap = null;
        byte[] b = os.toByteArray();
        if (b.length != 0) {
            bitmap = BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        }
        return bitmap;
    }

    public static Bitmap compressBitmapByPath(String srcPath, float pixelW, float pixelH) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = pixelH;
        float ww = pixelW;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    public static Bitmap compressBitmapByBmp(Bitmap image, float pixelW, float pixelH) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)os);
        if (os.toByteArray().length / 1024 > 1024) {
            os.reset();
            image.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)os);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = pixelH;
        float ww = pixelW;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        is = new ByteArrayInputStream(os.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)newOpts);
        int desWidth = w / be;
        int desHeight = h / be;
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)desWidth, (int)desHeight, (boolean)true);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilePathFromUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        ContentResolver resolver = context.getContentResolver();
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int read;
            ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r");
            if (pfd == null) {
                String string = null;
                return string;
            }
            FileDescriptor fd = pfd.getFileDescriptor();
            input = new FileInputStream(fd);
            File outputDir = context.getCacheDir();
            File outputFile = File.createTempFile("image", "tmp", outputDir);
            String tempFilename = outputFile.getAbsolutePath();
            output = new FileOutputStream(tempFilename);
            byte[] bytes = new byte[4096];
            while ((read = input.read(bytes)) != -1) {
                output.write(bytes, 0, read);
            }
            String string = new File(tempFilename).getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public static String toBase64(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        return Base64.encodeToString((byte[])bytes, (int)2);
    }

    public static Bitmap toBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int width = drawable.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap decodeResource(Context context, int resId) {
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static boolean isSoftInputVisible(@NonNull Activity activity) {
        return HyperLibUtils.getDecorViewInvisibleHeight(activity) > 0;
    }

    private static int getDecorViewInvisibleHeight(Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return 0;
        }
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        HyperLogUtils.d("getDecorViewInvisibleHeight: " + (decorView.getBottom() - outRect.bottom));
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= HyperLibUtils.getNavBarHeight((Context)activity) + HyperLibUtils.getStatusBarHeight((Context)activity)) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    private static int getStatusBarHeight(Context context) {
        Resources resources = context.getApplicationContext().getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    private static int getNavBarHeight(Context context) {
        Resources res = context.getApplicationContext().getResources();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static void hideSoftInput(@NonNull Activity activity) {
        View view = activity.getCurrentFocus();
        if (view == null) {
            View decorView = activity.getWindow().getDecorView();
            View focusView = decorView.findViewWithTag((Object)"keyboardTagView");
            if (focusView == null) {
                view = new EditText((Context)activity);
                view.setTag((Object)"keyboardTagView");
                ((ViewGroup)decorView).addView(view, 0, 0);
            } else {
                view = focusView;
            }
            view.requestFocus();
        }
        HyperLibUtils.hideSoftInput((Context)activity, view);
    }

    public static void hideSoftInput(Context context, @NonNull View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void openSoftInput(@NonNull Activity activity) {
        if (!HyperLibUtils.isSoftInputVisible(activity)) {
            HyperLibUtils.toggleSoftInput((Context)activity);
        }
    }

    public static void openSoftInput(Activity activity, View view) {
        HyperLibUtils.openSoftInput((Context)activity, view, 0);
    }

    private static void openSoftInput(final Context context, @NonNull View view, int flags) {
        InputMethodManager imm = (InputMethodManager)context.getApplicationContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, flags, new ResultReceiver(new Handler()){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 1 || resultCode == 3) {
                    HyperLibUtils.toggleSoftInput(context);
                }
            }
        });
        imm.toggleSoftInput(2, 1);
    }

    private static void toggleSoftInput(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getApplicationContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(0, 0);
    }
}

